/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.paperlib.PaperLib;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.util.SavePositionProvider;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.World;

public interface BukkitSavePositionProvider
extends SavePositionProvider {
    @Override
    default public CompletableFuture<Optional<Location>> findSafeGroundLocation(@NotNull Location location) {
        org.bukkit.Location bukkitLocation = BukkitHuskHomes.Adapter.adapt(location);
        if (bukkitLocation == null || bukkitLocation.getWorld() == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (!bukkitLocation.getWorld().getWorldBorder().isInside(bukkitLocation)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return ((CompletableFuture)PaperLib.getChunkAtAsync(bukkitLocation).thenApply(Chunk::getChunkSnapshot)).thenApply(snapshot -> this.findSafeLocationNear(location, (ChunkSnapshot)snapshot, this.getMinHeight(bukkitLocation.getWorld()), this.getMaxHeight(bukkitLocation.getWorld())));
    }

    private Optional<Location> findSafeLocationNear(@NotNull Location location, @NotNull ChunkSnapshot chunk, int minY, int maxY) {
        int chunkX = (int)location.getX() & 0xF;
        int chunkZ = (int)location.getZ() & 0xF;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                Optional<Integer> y;
                int x = chunkX + dx;
                int z = chunkZ + dz;
                if (x < 0 || x >= 16 || z < 0 || z >= 16 || !(y = this.getY(location, chunk, minY, maxY, x, z)).isPresent()) continue;
                double locx = Math.floor(location.getX()) + (double)dx;
                locx = locx < 0.0 ? (locx += 1.5) : (locx += 0.5);
                double locz = Math.floor(location.getZ()) + (double)dz;
                locz = locz < 0.0 ? (locz += 1.5) : (locz += 0.5);
                return Optional.of(Location.at(locx, y.get().intValue(), locz, location.getWorld()));
            }
        }
        return Optional.empty();
    }

    private boolean isSafeLocation(@NotNull ChunkSnapshot chunk, int x, int y, int z) {
        Material blockType = chunk.getBlockType(x, y - 1, z);
        Material bodyBlockType = chunk.getBlockType(x, y, z);
        Material headBlockType = chunk.getBlockType(x, y + 1, z);
        return this.isBlockSafeForStanding(blockType.getKey().toString()) && this.isBlockSafeForOccupation(bodyBlockType.getKey().toString()) && this.isBlockSafeForOccupation(headBlockType.getKey().toString());
    }

    private Optional<Integer> getY(@NotNull Location location, @NotNull ChunkSnapshot chunk, int minY, int maxY, int x, int z) {
        if (location.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            for (int y = minY + 1; y < Math.min(chunk.getHighestBlockYAt(x, z), maxY); ++y) {
                if (!this.isSafeLocation(chunk, x, y, z)) continue;
                return Optional.of(y);
            }
            return Optional.empty();
        }
        int y = Math.max(minY + 1, Math.min(chunk.getHighestBlockYAt(x, z), maxY)) + 1;
        return this.isSafeLocation(chunk, x, y, z) ? Optional.of(y) : Optional.empty();
    }

    private int getMinHeight(World world) {
        int minHeight = world.getMinHeight();
        for (String pair : this.getPlugin().getSettings().getRtp().getMinHeight()) {
            String worldName = pair.split(":")[0];
            int settingsHeight = Integer.parseInt(pair.split(":")[1]);
            if (!(world.getName().equals(worldName) & settingsHeight >= minHeight)) continue;
            minHeight = settingsHeight;
        }
        return minHeight;
    }

    private int getMaxHeight(World world) {
        int maxHeight = world.getMaxHeight();
        for (String pair : this.getPlugin().getSettings().getRtp().getMaxHeight()) {
            String worldName = pair.split(":")[0];
            int settingsHeight = Integer.parseInt(pair.split(":")[1]);
            if (!(world.getName().equals(worldName) & settingsHeight >= maxHeight)) continue;
            maxHeight = settingsHeight;
        }
        return maxHeight;
    }
}

