/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.paperlib.scheduling.AsynchronousScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.AttachedScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.RegionalScheduler;
import net.william278.huskhomes.libraries.paperlib.scheduling.ScheduledTask;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.Task;

public interface BukkitTask
extends Task {
    default public boolean isPluginDisabled() {
        return !((BukkitHuskHomes)this.getPlugin()).isEnabled();
    }

    public static interface Supplier
    extends Task.Supplier {
        @Override
        @NotNull
        default public Task.Sync getSyncTask(@NotNull Runnable runnable, @Nullable OnlineUser user, long delayTicks) {
            return new Sync(this.getPlugin(), runnable, user, delayTicks);
        }

        @Override
        @NotNull
        default public Task.Async getAsyncTask(@NotNull Runnable runnable, long delayTicks) {
            return new Async(this.getPlugin(), runnable, delayTicks);
        }

        @Override
        @NotNull
        default public Task.Repeating getRepeatingTask(@NotNull Runnable runnable, long repeatingTicks) {
            return new Repeating(this.getPlugin(), runnable, repeatingTicks);
        }

        @Override
        default public void cancelTasks() {
            ((BukkitHuskHomes)this.getPlugin()).getScheduler().cancelGlobalTasks();
        }
    }

    public static class Repeating
    extends Task.Repeating
    implements BukkitTask {
        private ScheduledTask task;

        protected Repeating(@NotNull HuskHomes plugin, @NotNull Runnable runnable, long repeatingTicks) {
            super(plugin, runnable, repeatingTicks);
        }

        @Override
        public void cancel() {
            if (this.task != null && !this.cancelled) {
                this.task.cancel();
            }
            super.cancel();
        }

        @Override
        public void run() {
            if (this.isPluginDisabled()) {
                return;
            }
            if (!this.cancelled) {
                AsynchronousScheduler scheduler = ((BukkitHuskHomes)this.getPlugin()).getAsyncScheduler();
                this.task = scheduler.runAtFixedRate(this.runnable, Duration.ZERO, Duration.of(this.repeatingTicks * 50L, ChronoUnit.MILLIS));
            }
        }
    }

    public static class Async
    extends Task.Async
    implements BukkitTask {
        private ScheduledTask task;

        protected Async(@NotNull HuskHomes plugin, @NotNull Runnable runnable, long delayTicks) {
            super(plugin, runnable, delayTicks);
        }

        @Override
        public void cancel() {
            if (this.task != null && !this.cancelled) {
                this.task.cancel();
            }
            super.cancel();
        }

        @Override
        public void run() {
            if (this.isPluginDisabled()) {
                this.runnable.run();
                return;
            }
            if (this.cancelled) {
                return;
            }
            AsynchronousScheduler scheduler = ((BukkitHuskHomes)this.getPlugin()).getAsyncScheduler();
            this.task = this.delayTicks > 0L ? scheduler.runDelayed(this.runnable, Duration.of(this.delayTicks * 50L, ChronoUnit.MILLIS)) : scheduler.run(this.runnable);
        }
    }

    public static class Sync
    extends Task.Sync
    implements BukkitTask {
        private ScheduledTask task;
        @Nullable
        private final OnlineUser user;

        protected Sync(@NotNull HuskHomes plugin, @NotNull Runnable runnable, @Nullable OnlineUser user, long delayTicks) {
            super(plugin, runnable, delayTicks);
            this.user = user;
        }

        @Override
        public void cancel() {
            if (this.task != null && !this.cancelled) {
                this.task.cancel();
            }
            super.cancel();
        }

        @Override
        public void run() {
            if (this.isPluginDisabled()) {
                this.runnable.run();
                return;
            }
            if (this.cancelled) {
                return;
            }
            if (this.user != null) {
                AttachedScheduler scheduler = ((BukkitHuskHomes)this.getPlugin()).getUserSyncScheduler(this.user);
                this.task = this.delayTicks > 0L ? scheduler.runDelayed(this.runnable, null, this.delayTicks) : scheduler.run(this.runnable, null);
                return;
            }
            RegionalScheduler scheduler = ((BukkitHuskHomes)this.getPlugin()).getSyncScheduler();
            this.task = this.delayTicks > 0L ? scheduler.runDelayed(this.runnable, this.delayTicks) : scheduler.run(this.runnable);
        }
    }
}

