/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.UserListTabCompletable;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportBuilder;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.TransactionResolver;

public class RtpCommand
extends Command
implements UserListTabCompletable {
    private final Random random = new Random();

    protected RtpCommand(@NotNull HuskHomes plugin) {
        super(List.of("rtp"), "[player] [<world> [server]|<world>]", plugin);
        this.addAdditionalPermissions(Map.of("other", true));
    }

    @Override
    public void execute(@NotNull CommandUser executor, @NotNull String[] args) {
        Optional optionalTeleporter;
        Optional<Object> optional = args.length >= 1 ? this.plugin.getOnlineUser(args[0]) : (optionalTeleporter = executor instanceof OnlineUser ? Optional.of((OnlineUser)executor) : Optional.empty());
        if (optionalTeleporter.isEmpty()) {
            if (args.length == 0) {
                this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
                return;
            }
            this.plugin.getLocales().getLocale("error_player_not_found", args[0]).ifPresent(executor::sendMessage);
            return;
        }
        OnlineUser teleporter = (OnlineUser)optionalTeleporter.get();
        String worldName = teleporter.getPosition().getWorld().getName();
        String targetServer = null;
        if (args.length == 2) {
            if (this.plugin.getSettings().getRtp().getRandomTargetServers().containsKey(args[1])) {
                targetServer = args[1];
                worldName = teleporter.getPosition().getWorld().getName();
            } else {
                worldName = args[1];
            }
        } else if (args.length > 2) {
            worldName = args[1];
            targetServer = args[2];
        }
        this.validateRtp(teleporter, executor, worldName.replace("minecraft:", ""), targetServer).ifPresent(entry -> this.executeRtp(teleporter, executor, (World)entry.getKey(), (String)entry.getValue(), args));
    }

    @Override
    @Nullable
    public List<String> suggest(@NotNull CommandUser user, @NotNull String[] args) {
        return switch (args.length) {
            case 0, 1 -> {
                if (user.hasPermission(this.getPermission("other"))) {
                    yield UserListTabCompletable.super.suggest(user, args);
                }
                if (user instanceof OnlineUser) {
                    OnlineUser online = (OnlineUser)user;
                    yield List.of(online.getName());
                }
                yield List.of();
            }
            case 2 -> {
                String input = args[1].toLowerCase();
                ArrayList<String> possibleSuggestions = new ArrayList<String>();
                possibleSuggestions.addAll(this.plugin.getSettings().getRtp().getRandomTargetServers().keySet().stream().filter(server -> user.hasPermission(this.getPermission((String)server))).toList());
                possibleSuggestions.addAll(this.plugin.getWorlds().stream().filter(world -> !this.plugin.getSettings().getRtp().isWorldRtpRestricted((World)world)).map(World::getName).filter(world -> user.hasPermission(this.getPermission((String)world))).toList());
                if (!input.isEmpty()) {
                    yield possibleSuggestions.stream().filter(suggestion -> suggestion.toLowerCase().startsWith(input)).toList();
                }
                yield possibleSuggestions;
            }
            case 3 -> {
                String worldName = args[1];
                ArrayList<String> possibleSuggestions = new ArrayList<String>(this.plugin.getWorlds().stream().filter(world -> !this.plugin.getSettings().getRtp().isWorldRtpRestricted((World)world)).map(World::getName).filter(world -> user.hasPermission(this.getPermission((String)world))).toList());
                if (possibleSuggestions.contains(worldName)) {
                    yield this.plugin.getSettings().getRtp().getRandomTargetServers().entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(worldName)).map(Map.Entry::getKey).toList();
                }
                yield List.of();
            }
            default -> null;
        };
    }

    private Optional<Map.Entry<World, String>> validateRtp(@NotNull OnlineUser teleporter, @NotNull CommandUser executor, @NotNull String worldName, @Nullable String targetServer) {
        if (!executor.equals(teleporter) && !executor.hasPermission(this.getPermission("other"))) {
            this.plugin.getLocales().getLocale("error_no_permission").ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        if (!this.plugin.validateTransaction(teleporter, TransactionResolver.Action.RANDOM_TELEPORT)) {
            return Optional.empty();
        }
        if (this.plugin.getSettings().getRtp().isCrossServer() && !this.plugin.getServerName().equals(targetServer)) {
            return this.validateCrossServerRtp(executor, worldName, targetServer);
        }
        Optional<World> localWorld = this.plugin.getWorlds().stream().filter(world -> world.getName().replace("minecraft:", "").equalsIgnoreCase(worldName)).findFirst();
        if (localWorld.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_world", worldName).ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        if (this.plugin.getSettings().getRtp().isWorldRtpRestricted(localWorld.get())) {
            this.plugin.getLocales().getLocale("error_rtp_restricted_world").ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        return localWorld.map(world -> new AbstractMap.SimpleImmutableEntry<World, String>((World)world, worldName));
    }

    private Optional<Map.Entry<World, String>> validateCrossServerRtp(CommandUser executor, String worldName, String targetServer) {
        String selectedServer;
        Map<String, List<String>> randomTargetServers = this.plugin.getSettings().getRtp().getRandomTargetServers();
        List<String> eligibleServers = randomTargetServers.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(worldName)).map(Map.Entry::getKey).toList();
        String string = targetServer != null ? targetServer : (selectedServer = !eligibleServers.isEmpty() ? eligibleServers.get(this.random.nextInt(eligibleServers.size())) : null);
        if (selectedServer == null || targetServer != null && !eligibleServers.contains(targetServer)) {
            this.plugin.getLocales().getLocale("error_invalid_world", worldName).ifPresent(executor::sendMessage);
            return Optional.empty();
        }
        Optional<World> targetWorld = this.plugin.getWorlds().stream().filter(world -> world.getName().replace("minecraft:", "").equalsIgnoreCase(worldName)).findFirst().or(() -> Optional.of(World.from(worldName)));
        return targetWorld.map(world -> new AbstractMap.SimpleImmutableEntry<World, String>((World)world, selectedServer));
    }

    private void executeRtp(@NotNull OnlineUser teleporter, @NotNull CommandUser executor, @NotNull World world, @NotNull String targetServer, @NotNull String[] args) {
        this.plugin.getLocales().getLocale("teleporting_random_generation").ifPresent(teleporter::sendMessage);
        if (this.plugin.getSettings().getRtp().isCrossServer() && this.plugin.getSettings().getCrossServer().isEnabled() && this.plugin.getSettings().getCrossServer().getBrokerType() == Broker.Type.REDIS) {
            if (targetServer.equals(this.plugin.getServerName())) {
                this.performLocalRTP(teleporter, executor, world, args);
                return;
            }
            this.plugin.getBroker().ifPresent(b -> Message.builder().type(Message.MessageType.REQUEST_RTP_LOCATION).target(targetServer, Message.TargetType.SERVER).payload(Payload.string(world.getName())).build().send((Broker)b, teleporter));
            return;
        }
        this.performLocalRTP(teleporter, executor, world, args);
    }

    private void performLocalRTP(@NotNull OnlineUser teleporter, @NotNull CommandUser executor, @NotNull World world, @NotNull String[] args) {
        this.plugin.getRandomTeleportEngine().getRandomPosition(world, args.length > 1 ? this.removeFirstArg(args) : args).thenAccept(position -> {
            if (position.isEmpty()) {
                this.plugin.getLocales().getLocale("error_rtp_randomization_timeout").ifPresent(executor::sendMessage);
                return;
            }
            TeleportBuilder builder = Teleport.builder(this.plugin).teleporter(teleporter).type(Teleport.Type.RANDOM_TELEPORT).actions(TransactionResolver.Action.RANDOM_TELEPORT).target((Target)position.get());
            builder.buildAndComplete(executor.equals(teleporter), args);
        });
    }
}

