/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.InGameCommand;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.Payload;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;

public class TpAllCommand
extends InGameCommand {
    protected TpAllCommand(@NotNull HuskHomes plugin) {
        super(List.of("tpall"), "", plugin);
        this.setOperatorCommand(true);
    }

    @Override
    public void execute(@NotNull OnlineUser executor, @NotNull String[] args) {
        if (this.plugin.getUserList().size() <= 1) {
            this.plugin.getLocales().getLocale("error_no_players_online").ifPresent(executor::sendMessage);
            return;
        }
        Position targetPosition = executor.getPosition();
        try {
            for (OnlineUser user : this.plugin.getOnlineUsers()) {
                if (!user.isValid()) continue;
                Teleport.builder(this.plugin).teleporter(user).target(targetPosition).toTeleport().execute();
            }
        }
        catch (TeleportationException e) {
            e.displayMessage(executor, args);
            return;
        }
        this.plugin.getBroker().ifPresent(b -> Message.builder().target("ALL", Message.TargetType.PLAYER).type(Message.MessageType.TELEPORT_TO_POSITION).payload(Payload.position(targetPosition)).build().send((Broker)b, executor));
        this.plugin.getLocales().getLocale("teleporting_all_players").ifPresent(executor::sendMessage);
    }
}

