/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.config;

import java.nio.file.Path;
import lombok.Generated;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.configlib.Configuration;

@Configuration
public class Server {
    static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503    HuskHomes - Server ID    \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 This file should contain the ID of this server as defined in your proxy config.\n\u2523\u2578 If you join it using /server alpha, then set it to 'alpha' (case-sensitive)\n\u2517\u2578 You only need to touch this if you're using cross-server mode.";
    private String name = Server.getDefault();

    @NotNull
    public static Server of(@NotNull String name) {
        return new Server(name);
    }

    @NotNull
    private static String getDefault() {
        String serverFolder = System.getProperty("user.dir");
        return serverFolder == null ? "server" : Path.of(serverFolder, new String[0]).getFileName().toString().trim();
    }

    public boolean equals(@NotNull Object other) {
        if (other instanceof Server) {
            Server server = (Server)other;
            return server.getName().equalsIgnoreCase(this.getName());
        }
        return super.equals(other);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    private Server() {
    }

    @Generated
    private Server(String name) {
        this.name = name;
    }
}

