/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import java.util.Set;
import java.util.stream.Collectors;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.hook.MapHook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Unmodifiable;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.User;

public interface MapHookProvider {
    @NotNull
    default public @Unmodifiable Set<MapHook> getMapHooks() {
        return this.getHooks().stream().filter(hook -> hook instanceof MapHook).map(hook -> (MapHook)hook).collect(Collectors.toSet());
    }

    default public void addMappedHome(@NotNull Home home) {
        this.getMapHooks().forEach(h -> h.addHome(home));
    }

    default public void removeMappedHome(@NotNull Home home) {
        this.getMapHooks().forEach(h -> h.removeHome(home));
    }

    default public void removeAllMappedHomes(@NotNull String worldName) {
        this.getMapHooks().forEach(h -> h.clearHomes(worldName));
    }

    default public void removeAllMappedHomes(@NotNull User user) {
        this.getMapHooks().forEach(h -> h.clearHomes(user));
    }

    default public void addMappedWarp(@NotNull Warp warp) {
        this.getMapHooks().forEach(h -> h.addWarp(warp));
    }

    default public void removeMappedWarp(@NotNull Warp warp) {
        this.getMapHooks().forEach(h -> h.removeWarp(warp));
    }

    default public void removeAllMappedWarps(@NotNull String worldName) {
        this.getMapHooks().forEach(h -> h.clearWarps(worldName));
    }

    default public void removeAllMappedWarps() {
        this.getMapHooks().forEach(MapHook::clearWarps);
    }

    @NotNull
    public Set<Hook> getHooks();
}

