/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import net.milkbowl.vault.economy.Economy;
import net.william278.huskhomes.BukkitHuskHomes;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.hook.EconomyHook;
import net.william278.huskhomes.hook.PluginHook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.user.BukkitUser;
import net.william278.huskhomes.user.OnlineUser;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

@PluginHook(name="Vault", register=PluginHook.Register.ON_ENABLE)
public class VaultEconomyHook
extends EconomyHook {
    protected Economy economy;

    public VaultEconomyHook(@NotNull HuskHomes plugin) {
        super(plugin);
    }

    @Override
    public void load() {
        RegisteredServiceProvider economyProvider = ((BukkitHuskHomes)this.plugin).getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
    }

    @Override
    public void unload() {
        this.economy = null;
    }

    @Override
    public double getPlayerBalance(@NotNull OnlineUser player) {
        return this.economy.getBalance((OfflinePlayer)((BukkitUser)player).getPlayer());
    }

    @Override
    public void changePlayerBalance(@NotNull OnlineUser player, double amount) {
        if (amount != 0.0) {
            Player bukkitPlayer = ((BukkitUser)player).getPlayer();
            double currentBalance = this.getPlayerBalance(player);
            double amountToChange = Math.abs(currentBalance - Math.max(0.0, currentBalance + amount));
            if (amount < 0.0) {
                this.economy.withdrawPlayer((OfflinePlayer)bukkitPlayer, amountToChange);
            } else {
                this.economy.depositPlayer((OfflinePlayer)bukkitPlayer, amountToChange);
            }
        }
    }

    @Override
    public String formatCurrency(double amount) {
        return this.economy.format(amount);
    }
}

