/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.paginedown;

import java.awt.Color;
import net.william278.huskhomes.libraries.annotations.NotNull;

public class ListOptions {
    @NotNull
    protected String headerFormat = "[Viewing %topic%](%color%) [(%first_item_on_page_index%-%last_item_on_page_index% of](%color%) [%total_items%](%color% bold)[)](%color%)";
    @NotNull
    protected String footerFormat = "%previous_page_button%Page [%current_page%](%color%)/[%total_pages%](%color%)%next_page_button%   %page_jumpers%";
    @NotNull
    protected String previousButtonFormat = "[\u25c1](white show_text=%color%View previous page \\(%previous_page_index%\\) run_command=/%command% %previous_page_index%) ";
    @NotNull
    protected String nextButtonFormat = " [\u25b7](white show_text=%color%View next page \\(%next_page_index%\\) run_command=/%command% %next_page_index%)";
    @NotNull
    protected String pageJumpersFormat = "(%page_jump_buttons%)";
    @NotNull
    protected String pageJumperPageSeparator = "|";
    @NotNull
    protected String pageJumperGroupSeparator = "\u2026";
    @NotNull
    protected String pageJumperCurrentPageFormat = "[%current_page%](%color%)";
    @NotNull
    protected String pageJumperPageFormat = "[%target_page_index%](show_text=&7Jump to page %target_page_index% run_command=/%command% %target_page_index%)";
    @NotNull
    protected String topic = "List";
    @NotNull
    protected String command = "example";
    @NotNull
    protected Color themeColor = new Color(64410);
    protected boolean spaceAfterHeader = true;
    protected boolean spaceBeforeFooter = true;
    protected boolean escapeItemsMineDown = true;
    @NotNull
    protected String itemSeparator = "\n";
    protected int itemsPerPage = 10;
    protected int pageJumperStartButtons = 3;
    protected int pageJumperEndButtons = 3;

    private ListOptions() {
    }

    public static class Builder {
        @NotNull
        private final ListOptions options = new ListOptions();

        @NotNull
        public Builder setHeaderFormat(@NotNull String headerFormat) {
            this.options.headerFormat = headerFormat;
            return this;
        }

        @NotNull
        public Builder setFooterFormat(@NotNull String footerFormat) {
            this.options.footerFormat = footerFormat;
            return this;
        }

        @NotNull
        public Builder setItemSeparator(@NotNull String itemSeparator) {
            this.options.itemSeparator = itemSeparator;
            return this;
        }

        @NotNull
        public Builder setThemeColor(@NotNull Color themeColor) {
            this.options.themeColor = themeColor;
            return this;
        }

        @NotNull
        public Builder setSpaceAfterHeader(boolean spaceAfterHeader) {
            this.options.spaceAfterHeader = spaceAfterHeader;
            return this;
        }

        @NotNull
        public Builder setSpaceBeforeFooter(boolean spaceBeforeFooter) {
            this.options.spaceBeforeFooter = spaceBeforeFooter;
            return this;
        }

        @NotNull
        public Builder setItemsPerPage(int itemsPerPage) {
            this.options.itemsPerPage = itemsPerPage;
            return this;
        }

        @NotNull
        public Builder setTopic(@NotNull String topic) {
            this.options.topic = topic;
            return this;
        }

        @NotNull
        public Builder setCommand(@NotNull String command) {
            this.options.command = command;
            return this;
        }

        @NotNull
        public Builder setEscapeItemsMineDown(boolean escapeItemsMineDown) {
            this.options.escapeItemsMineDown = escapeItemsMineDown;
            return this;
        }

        @NotNull
        public Builder setPageJumpersFormat(@NotNull String pageJumpersFormat) {
            this.options.pageJumpersFormat = pageJumpersFormat;
            return this;
        }

        @NotNull
        public Builder setPageJumperPageSeparator(@NotNull String pageJumperPageSeparator) {
            this.options.pageJumperPageSeparator = pageJumperPageSeparator;
            return this;
        }

        @NotNull
        public Builder setPageJumperPageFormat(@NotNull String pageJumperPageFormat) {
            this.options.pageJumperPageFormat = pageJumperPageFormat;
            return this;
        }

        @NotNull
        public Builder setPageJumperGroupSeparator(@NotNull String pageJumperGroupSeparator) {
            this.options.pageJumperGroupSeparator = pageJumperGroupSeparator;
            return this;
        }

        @NotNull
        public Builder setPageJumperCurrentPageFormat(@NotNull String pageJumperCurrentPageFormat) {
            this.options.pageJumperCurrentPageFormat = pageJumperCurrentPageFormat;
            return this;
        }

        @NotNull
        public Builder setPreviousButtonFormat(@NotNull String previousButtonFormat) {
            this.options.previousButtonFormat = previousButtonFormat;
            return this;
        }

        @NotNull
        public Builder setNextButtonFormat(@NotNull String nextButtonFormat) {
            this.options.nextButtonFormat = nextButtonFormat;
            return this;
        }

        @NotNull
        public Builder setPageJumperStartButtons(int pageJumperStartButtons) {
            this.options.pageJumperStartButtons = pageJumperStartButtons;
            return this;
        }

        @NotNull
        public Builder setPageJumperEndButtons(int pageJumperEndButtons) {
            this.options.pageJumperEndButtons = pageJumperEndButtons;
            return this;
        }

        @NotNull
        public ListOptions build() {
            return this.options;
        }
    }
}

