/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.libraries.paginedown;

import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.libraries.paginedown.ListOptions;
import net.william278.huskhomes.libraries.paginedown.PaginationException;

public class PaginatedList {
    @NotNull
    private final ListOptions options;
    @NotNull
    private final List<String> items;

    private PaginatedList(@NotNull List<String> items, @NotNull ListOptions options) {
        this.items = items;
        this.options = options;
    }

    @NotNull
    public static PaginatedList of(@NotNull List<String> items) {
        return new PaginatedList(items, new ListOptions.Builder().build());
    }

    @NotNull
    public static PaginatedList of(@NotNull List<String> items, @NotNull ListOptions options) {
        return new PaginatedList(items, options);
    }

    @NotNull
    public MineDown getNearestValidPage(int page) {
        return this.getPage(Math.max(1, Math.min(this.getTotalPages(), page)));
    }

    public MineDown getPage(int page) throws PaginationException {
        return new MineDown(this.getRawPage(page));
    }

    @NotNull
    public String getRawPage(int page) throws PaginationException {
        if (page < 1) {
            throw new PaginationException("Page index must be >= 1");
        }
        if (page > this.getTotalPages()) {
            throw new PaginationException("Page index must be <= the total number of pages (" + this.getTotalPages() + ")");
        }
        StringJoiner menuJoiner = new StringJoiner("\n");
        if (!this.options.headerFormat.isBlank()) {
            menuJoiner.add(this.formatPageString(this.options.headerFormat, page));
            if (this.options.spaceAfterHeader) {
                menuJoiner.add("");
            }
        }
        if (this.options.escapeItemsMineDown) {
            menuJoiner.add(this.getItemsForPage(page).stream().map(MineDown::escape).collect(Collectors.joining(this.options.itemSeparator)));
        } else {
            menuJoiner.add(String.join((CharSequence)this.options.itemSeparator, this.getItemsForPage(page)));
        }
        if (!this.options.footerFormat.isBlank()) {
            if (this.options.spaceBeforeFooter) {
                menuJoiner.add("");
            }
            menuJoiner.add(this.formatPageString(this.options.footerFormat, page));
        }
        return menuJoiner.toString();
    }

    public int getTotalPages() {
        return (int)Math.ceil((double)this.items.size() / (double)this.options.itemsPerPage);
    }

    @NotNull
    private List<String> getItemsForPage(int page) {
        return this.items.subList((page - 1) * this.options.itemsPerPage, Math.min(this.items.size(), page * this.options.itemsPerPage));
    }

    @NotNull
    private String formatPageString(@NotNull String format, int page) {
        StringBuilder convertedFormat = new StringBuilder();
        StringBuilder currentPlaceholder = new StringBuilder();
        boolean readingPlaceholder = false;
        for (char c : format.toCharArray()) {
            if (c == '%') {
                if (readingPlaceholder) {
                    switch (currentPlaceholder.toString().toLowerCase()) {
                        case "topic": {
                            convertedFormat.append(this.formatPageString(this.options.topic, page));
                            break;
                        }
                        case "color": {
                            convertedFormat.append(String.format("#%02x%02x%02x", this.options.themeColor.getRed(), this.options.themeColor.getGreen(), this.options.themeColor.getBlue()));
                            break;
                        }
                        case "first_item_on_page_index": {
                            convertedFormat.append((page - 1) * this.options.itemsPerPage + 1);
                            break;
                        }
                        case "last_item_on_page_index": {
                            convertedFormat.append((page - 1) * this.options.itemsPerPage + this.getItemsForPage(page).size());
                            break;
                        }
                        case "total_items": {
                            convertedFormat.append(this.items.size());
                            break;
                        }
                        case "current_page": {
                            convertedFormat.append(page);
                            break;
                        }
                        case "total_pages": {
                            convertedFormat.append(this.getTotalPages());
                            break;
                        }
                        case "previous_page_button": {
                            if (page <= 1) break;
                            convertedFormat.append(this.formatPageString(this.options.previousButtonFormat, page));
                            break;
                        }
                        case "next_page_button": {
                            if (page >= this.getTotalPages()) break;
                            convertedFormat.append(this.formatPageString(this.options.nextButtonFormat, page));
                            break;
                        }
                        case "next_page_index": {
                            convertedFormat.append(page + 1);
                            break;
                        }
                        case "previous_page_index": {
                            convertedFormat.append(page - 1);
                            break;
                        }
                        case "command": {
                            convertedFormat.append(this.options.command);
                            break;
                        }
                        case "page_jumpers": {
                            if (this.getTotalPages() <= 2) break;
                            convertedFormat.append(this.formatPageString(this.options.pageJumpersFormat, page));
                            break;
                        }
                        case "page_jump_buttons": {
                            convertedFormat.append(this.getPageJumperButtons(page));
                        }
                    }
                } else {
                    currentPlaceholder = new StringBuilder();
                }
                readingPlaceholder = !readingPlaceholder;
                continue;
            }
            if (readingPlaceholder) {
                currentPlaceholder.append(c);
                continue;
            }
            convertedFormat.append(c);
        }
        return convertedFormat.toString();
    }

    @NotNull
    private String formatPageJumper(int page) {
        return this.formatPageString(this.options.pageJumperPageFormat.replaceAll("%target_page_index%", Integer.toString(page)), page);
    }

    @NotNull
    protected String getPageJumperButtons(int page) {
        StringJoiner pageGroups = new StringJoiner(this.options.pageJumperGroupSeparator);
        StringJoiner pages = new StringJoiner(this.options.pageJumperPageSeparator);
        int lastPage = 1;
        for (int i = 1; i <= this.getTotalPages(); ++i) {
            if (i > this.options.pageJumperStartButtons && i <= this.getTotalPages() - this.options.pageJumperEndButtons && page != i) continue;
            if (i - lastPage > 1) {
                pageGroups.add(pages.toString());
                pages = new StringJoiner(this.options.pageJumperPageSeparator);
            }
            if (page == i) {
                pages.add(this.formatPageString(this.options.pageJumperCurrentPageFormat, i));
            } else {
                pages.add(this.formatPageString(this.formatPageJumper(i), i));
            }
            lastPage = i;
        }
        if (!pages.toString().isBlank()) {
            pageGroups.add(pages.toString());
        }
        return pageGroups.toString();
    }
}

