/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.random;

import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.network.Broker;
import net.william278.huskhomes.position.Location;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.random.RandomTeleportEngine;

public final class NormalDistributionEngine
extends RandomTeleportEngine {
    private final Settings.RtpSettings.RtpRadius radius;
    private final float mean;
    private final float standardDeviation;

    public NormalDistributionEngine(@NotNull HuskHomes plugin) {
        super(plugin, "Normal Distribution");
        this.radius = plugin.getSettings().getRtp().getRegion();
        this.mean = plugin.getSettings().getRtp().getDistributionMean();
        this.standardDeviation = plugin.getSettings().getRtp().getDistributionStandardDeviation();
        if (plugin.getSettings().getRtp().isCrossServer() && plugin.getSettings().getCrossServer().isEnabled() && plugin.getSettings().getCrossServer().getBrokerType() != Broker.Type.REDIS) {
            plugin.log(Level.WARNING, "Cross-server /rtp support has been disabled as a REDIS message broker is required for this feature.", new Throwable[0]);
        }
    }

    private static int determineSpawnRadius(int radius, int spawnRadius, @NotNull HuskHomes plugin) {
        if (spawnRadius >= radius) {
            plugin.log(Level.WARNING, "The RTP spawn radius is greater than or equal to the RTP radius. This will result in the RTP engine being unable to find a suitable location to teleport to. Please set the RTP spawn radius to a value less than the RTP radius.", new Throwable[0]);
            return radius - 1;
        }
        return spawnRadius;
    }

    @NotNull
    public static Location generateLocation(@NotNull Location origin, float mean, float standardDeviation, float spawnRadius, float maxRadius) {
        float radius = NormalDistributionEngine.getDistributedRadius(mean, standardDeviation, spawnRadius, maxRadius);
        float angle = NormalDistributionEngine.getRandomAngle();
        float z = (float)((double)radius * Math.cos(angle));
        float x = (float)((double)radius * Math.sin(angle));
        return Location.at((float)Math.round(origin.getX()) + x, 128.0, (float)Math.round(origin.getZ()) + z, origin.getWorld());
    }

    private CompletableFuture<Optional<Location>> generateSafeLocation(@NotNull World world) {
        return this.plugin.findSafeGroundLocation(NormalDistributionEngine.generateLocation(this.getCenterPoint(world), this.mean, this.standardDeviation, this.radius.getMin(), this.radius.getMax()));
    }

    private static float getDistributedRadius(float mean, float standardDeviation, float spawnRadius, float maxRadius) {
        double value = (new Random().nextGaussian() * (double)mean + (double)standardDeviation) * (double)maxRadius;
        if (value < (double)spawnRadius || value > (double)maxRadius) {
            return NormalDistributionEngine.getDistributedRadius(mean, standardDeviation, spawnRadius, maxRadius);
        }
        return (float)value;
    }

    private static float getRandomAngle() {
        return (float)(Math.random() * 360.0);
    }

    @Override
    public CompletableFuture<Optional<Position>> getRandomPosition(@NotNull World world, @NotNull String[] args) {
        return this.plugin.supplyAsync(() -> {
            Optional<Location> location = this.generateSafeLocation(world).join();
            int attempts = 0;
            while (location.isEmpty()) {
                location = this.generateSafeLocation(world).join();
                if ((long)attempts >= this.maxAttempts) {
                    return Optional.empty();
                }
                ++attempts;
            }
            return location.map(resolved -> Position.at(resolved, this.plugin.getServerName()));
        });
    }
}

