/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.hook;

import java.util.HashMap;
import java.util.Map;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.hook.Hook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.commons.text.StringEscapeUtils;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.User;

public abstract class MapHook
extends Hook {
    protected static final String WARP_MARKER_IMAGE_NAME = "warp";
    protected static final String PUBLIC_HOME_MARKER_IMAGE_NAME = "public-home";

    protected MapHook(@NotNull HuskHomes plugin) {
        super(plugin);
    }

    @Override
    public void unload() {
        this.getPlugin().getWorlds().forEach(world -> this.clearHomes(world.getName()));
        this.clearWarps();
    }

    protected void populateMap() {
        Settings.MapHookSettings settings = this.plugin.getSettings().getMapHook();
        if (settings.isShowPublicHomes()) {
            this.plugin.getDatabase().getLocalPublicHomes(this.plugin).forEach(this::addHome);
        }
        if (settings.isShowWarps()) {
            this.plugin.getDatabase().getLocalWarps(this.plugin).forEach(this::addWarp);
        }
    }

    public abstract void addHome(@NotNull Home var1);

    public abstract void removeHome(@NotNull Home var1);

    public abstract void clearHomes(@NotNull User var1);

    public abstract void clearHomes(@NotNull String var1);

    public abstract void addWarp(@NotNull Warp var1);

    public abstract void removeWarp(@NotNull Warp var1);

    public abstract void clearWarps();

    public abstract void clearWarps(@NotNull String var1);

    protected final boolean isValidPosition(@NotNull SavedPosition position) {
        Settings.MapHookSettings settings = this.plugin.getSettings().getMapHook();
        if (position instanceof Warp && !settings.isShowWarps()) {
            return false;
        }
        if (position instanceof Home && !settings.isShowPublicHomes()) {
            return false;
        }
        return !this.plugin.getSettings().getCrossServer().isEnabled() || position.getServer().equals(this.plugin.getServerName());
    }

    @NotNull
    protected final String getPublicHomesKey() {
        return this.plugin.getKey(this.getName().toLowerCase(), "public_home_markers").toString();
    }

    @NotNull
    protected final String getWarpsKey() {
        return this.plugin.getKey(this.getName().toLowerCase(), "warp_markers").toString();
    }

    @NotNull
    protected final String getPublicHomesMarkerSetName() {
        return this.plugin.getLocales().getRawLocale("map_hook_public_homes_marker_set_name").orElse("Public Homes");
    }

    @NotNull
    protected final String getWarpsMarkerSetName() {
        return this.plugin.getLocales().getRawLocale("map_hook_warps_marker_set_name").orElse("Warps");
    }

    protected static class MarkerInformationPopup {
        @NotNull
        private final String title;
        @Nullable
        private String thumbnail;
        @NotNull
        private final Map<String, String> fields;

        private MarkerInformationPopup(@NotNull String title) {
            this.title = title;
            this.fields = new HashMap<String, String>();
        }

        @NotNull
        protected static MarkerInformationPopup warp(@NotNull Warp warp, @NotNull String thumbnail) {
            MarkerInformationPopup popup = MarkerInformationPopup.create(warp.getName()).thumbnail(thumbnail).field("Location", warp.toString()).field("Command", "/warp " + warp.getSafeIdentifier());
            if (!warp.getMeta().getDescription().isBlank()) {
                popup.field("Description", warp.getMeta().getDescription());
            }
            return popup;
        }

        @NotNull
        protected static MarkerInformationPopup publicHome(@NotNull Home home, @NotNull String thumbnail) {
            MarkerInformationPopup popup = MarkerInformationPopup.create(home.getName()).thumbnail(thumbnail).field("Owner", home.getOwner().getName()).field("Location", home.toString()).field("Command", "/phome " + home.getSafeIdentifier());
            if (!home.getMeta().getDescription().isBlank()) {
                popup.field("Description", home.getMeta().getDescription());
            }
            return popup;
        }

        @NotNull
        protected static MarkerInformationPopup create(@NotNull String title) {
            return new MarkerInformationPopup(title);
        }

        @NotNull
        protected MarkerInformationPopup thumbnail(@NotNull String thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        @NotNull
        protected MarkerInformationPopup field(@NotNull String key, @NotNull String value) {
            this.fields.put(key, value);
            return this;
        }

        @NotNull
        protected String toHtml() {
            StringBuilder html = new StringBuilder();
            html.append("<div class=\"infowindow\">");
            if (this.thumbnail != null) {
                html.append("<img src=\"").append(this.thumbnail).append(".png\" class=\"thumbnail\"/>").append("&nbsp;");
            }
            html.append("<span style=\"font-weight: bold;\">").append(StringEscapeUtils.escapeHtml4(this.title)).append("</span><br/>");
            this.fields.forEach((key, value) -> html.append("<span style=\"font-weight: bold;\">").append(StringEscapeUtils.escapeHtml4(key)).append(": </span><span>").append(StringEscapeUtils.escapeHtml4(value)).append("</span><br/>"));
            return html.toString();
        }
    }
}

