/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.libraries.inventorygui;

import net.william278.huskhomes.gui.libraries.inventorygui.InventoryGui;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class GuiElement {
    private final char slotChar;
    private Action action;
    protected int[] slots = new int[0];
    protected InventoryGui gui;

    public GuiElement(char slotChar, Action action) {
        this.slotChar = slotChar;
        this.setAction(action);
    }

    public GuiElement(char slotChar) {
        this(slotChar, null);
    }

    public char getSlotChar() {
        return this.slotChar;
    }

    public abstract ItemStack getItem(HumanEntity var1, int var2);

    public Action getAction(HumanEntity who) {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public int[] getSlots() {
        return this.slots;
    }

    public void setSlots(int[] slots) {
        this.slots = slots;
    }

    public int getSlotIndex(int slot) {
        return this.getSlotIndex(slot, 0);
    }

    public int getSlotIndex(int slot, int pageNumber) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] != slot) continue;
            return i + this.slots.length * pageNumber;
        }
        return -1;
    }

    public void setGui(InventoryGui gui) {
        this.gui = gui;
    }

    public InventoryGui getGui() {
        return this.gui;
    }

    public static interface Action {
        public boolean onClick(Click var1);
    }

    public static class Click {
        private final InventoryGui gui;
        private final int slot;
        private final GuiElement element;
        private final InventoryClickEvent event;

        public Click(InventoryGui gui, int slot, GuiElement element, InventoryClickEvent event) {
            this.gui = gui;
            this.slot = slot;
            this.element = element;
            this.event = event;
        }

        public int getSlot() {
            return this.slot;
        }

        public GuiElement getElement() {
            return this.element;
        }

        public ClickType getType() {
            return this.event.getClick();
        }

        public HumanEntity getWhoClicked() {
            return this.event.getWhoClicked();
        }

        public InventoryClickEvent getEvent() {
            return this.event;
        }

        public InventoryGui getGui() {
            return this.gui;
        }
    }
}

