/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.chat.BaseComponent;
import net.william278.huskhomes.api.HuskHomesAPI;
import net.william278.huskhomes.gui.HuskHomesGui;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiElement;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiElementGroup;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiPageElement;
import net.william278.huskhomes.gui.libraries.inventorygui.InventoryGui;
import net.william278.huskhomes.gui.libraries.inventorygui.StaticGuiElement;
import net.william278.huskhomes.libraries.minedown.MineDown;
import net.william278.huskhomes.player.OnlineUser;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.PositionMeta;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.SavedPositionManager;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.util.Permission;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SavedPositionMenu {
    private static final String[] MENU_LAYOUT = new String[]{"ppppppppp", "ppppppppp", "ppppppppp", "bl     ne"};
    private static final String TAG_KEY = "huskhomesgui:icon";
    private final InventoryGui menu;
    private final HuskHomesAPI huskHomesAPI;
    private final MenuType menuType;

    protected static SavedPositionMenu create(@NotNull HuskHomesGui plugin, @NotNull List<? extends SavedPosition> savedPositions, @NotNull MenuType type, @NotNull String title) {
        return new SavedPositionMenu(plugin, HuskHomesAPI.getInstance(), savedPositions, type, title);
    }

    protected void show(@NotNull OnlineUser onlineUser) {
        this.menu.show((HumanEntity)this.huskHomesAPI.getPlayer(onlineUser));
    }

    private SavedPositionMenu(@NotNull HuskHomesGui plugin, @NotNull HuskHomesAPI huskHomesAPI, @NotNull List<? extends SavedPosition> positionList, @NotNull MenuType menuType, @NotNull String title) {
        this.menu = new InventoryGui((JavaPlugin)plugin, title, MENU_LAYOUT, new GuiElement[0]);
        this.menuType = menuType;
        this.huskHomesAPI = huskHomesAPI;
        this.menu.setFiller(new ItemStack(menuType.fillerMaterial, 1));
        this.menu.addElement(this.getPositionGroup(positionList));
        this.menu.addElement(new GuiPageElement('b', new ItemStack(Material.EGG), GuiPageElement.PageAction.FIRST, this.getLegacyText("[\u23ea View first page (\\1\\)](#00fb9a)")));
        this.menu.addElement(new GuiPageElement('l', new ItemStack(Material.ARROW), GuiPageElement.PageAction.PREVIOUS, this.getLegacyText("[\u25c0 View previous page \\(%prevpage%\\)](#00fb9a)")));
        this.menu.addElement(new GuiPageElement('n', new ItemStack(Material.SPECTRAL_ARROW), GuiPageElement.PageAction.NEXT, this.getLegacyText("[View next page \\(%nextpage%\\) \u25b6](#00fb9a)")));
        this.menu.addElement(new GuiPageElement('e', new ItemStack(Material.EGG), GuiPageElement.PageAction.LAST, this.getLegacyText("[View last page \\(%pages\\) \u23e9](#00fb9a)")));
    }

    @NotNull
    private GuiElementGroup getPositionGroup(@NotNull List<? extends SavedPosition> positions) {
        GuiElementGroup group = new GuiElementGroup('p', new GuiElement[0]);
        for (SavedPosition savedPosition : positions) {
            group.addElement(this.getPositionButton(savedPosition));
        }
        return group;
    }

    @NotNull
    private StaticGuiElement getPositionButton(@NotNull SavedPosition position) {
        return new StaticGuiElement('e', new ItemStack(this.getPositionMaterial(position).orElse(Material.STONE)), click -> {
            HumanEntity patt3616$temp = click.getWhoClicked();
            if (patt3616$temp instanceof Player) {
                Player player = (Player)patt3616$temp;
                OnlineUser onlineUser = this.huskHomesAPI.adaptUser(player);
                switch (click.getType()) {
                    case LEFT: {
                        this.menu.close(true);
                        this.huskHomesAPI.teleportPlayer(onlineUser, (Position)position, true);
                        break;
                    }
                    case RIGHT: {
                        this.menu.close(true);
                        player.performCommand(switch (this.menuType) {
                            default -> throw new IncompatibleClassChangeError();
                            case MenuType.HOME, MenuType.PUBLIC_HOME -> "huskhomes:edithome " + ((Home)position).owner.username + "." + position.meta.name;
                            case MenuType.WARP -> "huskhomes:editwarp " + position.meta.name;
                        });
                        break;
                    }
                    case SHIFT_LEFT: {
                        if (!this.canEditPosition(position, player) || player.getInventory().getItemInMainHand().getType() == Material.AIR) break;
                        this.menu.close(true);
                        this.setPositionMaterial(position, player.getInventory().getItemInMainHand().getType()).thenRun(() -> player.sendMessage(this.getLegacyText("[Successfully updated the icon for](#00fb9a) [%1%](#00fb9a bold)").replaceAll("%1%", position.meta.name)));
                    }
                }
            }
            return true;
        }, this.getLegacyText("[" + position.meta.name + "](#00fb9a)"), this.getLegacyText("&7\u2139 " + (position.meta.description.isBlank() ? this.huskHomesAPI.getRawLocale("item_no_description", new String[0]).orElse("N/A") : position.meta.description)), " ", this.getLegacyText("[Left Click:](#00fb9a) [Teleport](gray)"), this.getLegacyText("[Right Click:](#00fb9a) [Edit](gray)"), this.getLegacyText("[Shift Click:](#00fb9a) [Set icon](gray)"));
    }

    private Optional<Material> getPositionMaterial(@NotNull SavedPosition position) {
        if (position.meta.tags.containsKey(TAG_KEY)) {
            return Optional.ofNullable(Material.matchMaterial((String)((String)position.meta.tags.get(TAG_KEY))));
        }
        return Optional.empty();
    }

    private CompletableFuture<SavedPositionManager.SaveResult> setPositionMaterial(@NotNull SavedPosition position, @NotNull Material material) {
        PositionMeta meta = position.meta;
        meta.tags.put(TAG_KEY, material.getKey().toString());
        if (this.menuType == MenuType.WARP) {
            Warp warp = (Warp)position;
            return this.huskHomesAPI.updateWarpMeta(warp, meta);
        }
        Home home = (Home)position;
        return this.huskHomesAPI.updateHomeMeta(home, meta);
    }

    private boolean canEditPosition(@NotNull SavedPosition position, @NotNull Player player) {
        if (this.menuType == MenuType.WARP) {
            if (!player.hasPermission(Permission.COMMAND_EDIT_WARP.node)) {
                this.getLocale("error_no_permission", new String[0]).ifPresent(arg_0 -> ((Player)player).sendMessage(arg_0));
                return false;
            }
            return true;
        }
        if (this.menuType == MenuType.HOME || this.menuType == MenuType.PUBLIC_HOME) {
            Home home = (Home)position;
            if (player.getUniqueId().equals(home.owner.uuid)) {
                if (!player.hasPermission(Permission.COMMAND_EDIT_HOME.node)) {
                    this.getLocale("error_no_permission", new String[0]).ifPresent(arg_0 -> ((Player)player).sendMessage(arg_0));
                    return false;
                }
            } else if (!player.hasPermission(Permission.COMMAND_EDIT_HOME_OTHER.node)) {
                this.getLocale("error_no_permission", new String[0]).ifPresent(arg_0 -> ((Player)player).sendMessage(arg_0));
                return false;
            }
            return true;
        }
        return false;
    }

    @NotNull
    private Optional<String> getLocale(@NotNull String localeKey, String ... replacements) {
        return this.huskHomesAPI.getLocale(localeKey, replacements).map(MineDown::toComponent).map(BaseComponent::toLegacyText);
    }

    @NotNull
    private String getLegacyText(@NotNull String mineDown) {
        return BaseComponent.toLegacyText((BaseComponent[])new MineDown(mineDown).toComponent());
    }

    protected static enum MenuType {
        HOME(Material.ORANGE_STAINED_GLASS_PANE),
        PUBLIC_HOME(Material.LIME_STAINED_GLASS_PANE),
        WARP(Material.CYAN_STAINED_GLASS_PANE);

        private final Material fillerMaterial;

        private MenuType(Material fillerMaterial) {
            this.fillerMaterial = fillerMaterial;
        }
    }
}

