/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.libraries.inventorygui;

import java.util.function.Function;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiElement;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GuiStorageElement
extends GuiElement {
    private final Inventory storage;
    private final int invSlot;
    private Runnable applyStorage;
    private Function<ValidatorInfo, Boolean> itemValidator;

    public GuiStorageElement(char slotChar, Inventory storage) {
        this(slotChar, storage, -1);
    }

    public GuiStorageElement(char slotChar, Inventory storage, int invSlot) {
        this(slotChar, storage, invSlot, null, null);
    }

    public GuiStorageElement(char slotChar, Inventory storage, int invSlot, Runnable applyStorage, Function<ValidatorInfo, Boolean> itemValidator) {
        super(slotChar, null);
        this.invSlot = invSlot;
        this.applyStorage = applyStorage;
        this.itemValidator = itemValidator;
        this.setAction(click -> {
            if (this.getStorageSlot(click.getWhoClicked(), click.getSlot()) < 0) {
                return true;
            }
            ItemStack storageItem = this.getStorageItem(click.getWhoClicked(), click.getSlot());
            ItemStack slotItem = click.getEvent().getView().getTopInventory().getItem(click.getSlot());
            if (slotItem == null && storageItem != null && storageItem.getType() != Material.AIR || storageItem == null && slotItem != null && slotItem.getType() != Material.AIR || storageItem != null && !storageItem.equals((Object)slotItem)) {
                this.gui.draw(click.getEvent().getWhoClicked(), false);
                return true;
            }
            ItemStack movedItem = null;
            switch (click.getEvent().getAction()) {
                case NOTHING: 
                case CLONE_STACK: {
                    return false;
                }
                case MOVE_TO_OTHER_INVENTORY: {
                    if (click.getEvent().getRawSlot() < click.getEvent().getView().getTopInventory().getSize()) {
                        if (click.getEvent().getView().getBottomInventory().firstEmpty() == -1) {
                            return true;
                        }
                        movedItem = null;
                    } else {
                        if (click.getEvent().getView().getTopInventory().firstEmpty() == -1) {
                            return true;
                        }
                        movedItem = click.getEvent().getCurrentItem();
                    }
                    this.gui.getPlugin().getServer().getScheduler().runTask((Plugin)this.gui.getPlugin(), this.gui::draw);
                    break;
                }
                case HOTBAR_MOVE_AND_READD: 
                case HOTBAR_SWAP: {
                    int button = click.getEvent().getHotbarButton();
                    if (button < 0) {
                        return true;
                    }
                    ItemStack hotbarItem = click.getEvent().getView().getBottomInventory().getItem(button);
                    if (hotbarItem == null) break;
                    movedItem = hotbarItem.clone();
                    break;
                }
                case PICKUP_ONE: 
                case DROP_ONE_SLOT: {
                    movedItem = click.getEvent().getCurrentItem().clone();
                    movedItem.setAmount(movedItem.getAmount() - 1);
                    break;
                }
                case DROP_ALL_SLOT: {
                    movedItem = null;
                    break;
                }
                case PICKUP_HALF: {
                    movedItem = click.getEvent().getCurrentItem().clone();
                    movedItem.setAmount(movedItem.getAmount() / 2);
                    break;
                }
                case PLACE_SOME: {
                    if (click.getEvent().getCurrentItem() == null) {
                        movedItem = click.getEvent().getCursor();
                        break;
                    }
                    movedItem = click.getEvent().getCurrentItem().clone();
                    if (movedItem.getAmount() + click.getEvent().getCursor().getAmount() < movedItem.getMaxStackSize()) {
                        movedItem.setAmount(movedItem.getAmount() + click.getEvent().getCursor().getAmount());
                        break;
                    }
                    movedItem.setAmount(movedItem.getMaxStackSize());
                    break;
                }
                case PLACE_ONE: {
                    if (click.getEvent().getCurrentItem() == null) {
                        movedItem = click.getEvent().getCursor().clone();
                        movedItem.setAmount(1);
                        break;
                    }
                    movedItem = click.getEvent().getCursor().clone();
                    movedItem.setAmount(click.getEvent().getCurrentItem().getAmount() + 1);
                    break;
                }
                case PLACE_ALL: {
                    movedItem = click.getEvent().getCursor().clone();
                    if (click.getEvent().getCurrentItem() == null || click.getEvent().getCurrentItem().getAmount() <= 0) break;
                    movedItem.setAmount(click.getEvent().getCurrentItem().getAmount() + movedItem.getAmount());
                    break;
                }
                case PICKUP_ALL: 
                case SWAP_WITH_CURSOR: {
                    movedItem = click.getEvent().getCursor();
                    break;
                }
                case COLLECT_TO_CURSOR: {
                    if (click.getEvent().getCursor() == null || click.getEvent().getCurrentItem() != null && click.getEvent().getCurrentItem().getType() != Material.AIR) {
                        return true;
                    }
                    this.gui.simulateCollectToCursor(click);
                    return false;
                }
                default: {
                    click.getEvent().getWhoClicked().sendMessage(ChatColor.RED + "The action " + click.getEvent().getAction() + " is not supported! Sorry about that :(");
                    return true;
                }
            }
            return !this.setStorageItem(click.getWhoClicked(), click.getSlot(), movedItem);
        });
        this.storage = storage;
    }

    @Override
    public ItemStack getItem(HumanEntity who, int slot) {
        int index = this.getStorageSlot(who, slot);
        if (index > -1 && index < this.storage.getSize()) {
            return this.storage.getItem(index);
        }
        return null;
    }

    public Inventory getStorage() {
        return this.storage;
    }

    private int getStorageSlot(HumanEntity player, int slot) {
        int index;
        int n = index = this.invSlot != -1 ? this.invSlot : this.getSlotIndex(slot, this.gui.getPageNumber(player));
        if (index < 0 || index >= this.storage.getSize()) {
            return -1;
        }
        return index;
    }

    @Deprecated
    public ItemStack getStorageItem(int slot) {
        return this.getStorageItem(null, slot);
    }

    public ItemStack getStorageItem(HumanEntity player, int slot) {
        int index = this.getStorageSlot(player, slot);
        if (index == -1) {
            return null;
        }
        return this.storage.getItem(index);
    }

    @Deprecated
    public boolean setStorageItem(int slot, ItemStack item) {
        return this.setStorageItem(null, slot, item);
    }

    public boolean setStorageItem(HumanEntity player, int slot, ItemStack item) {
        int index = this.getStorageSlot(player, slot);
        if (index == -1) {
            return false;
        }
        if (!this.validateItem(slot, item)) {
            return false;
        }
        this.storage.setItem(index, item);
        if (this.applyStorage != null) {
            this.applyStorage.run();
        }
        return true;
    }

    public Runnable getApplyStorage() {
        return this.applyStorage;
    }

    public void setApplyStorage(Runnable applyStorage) {
        this.applyStorage = applyStorage;
    }

    public Function<ValidatorInfo, Boolean> getItemValidator() {
        return this.itemValidator;
    }

    public void setItemValidator(Function<ValidatorInfo, Boolean> itemValidator) {
        this.itemValidator = itemValidator;
    }

    public boolean validateItem(int slot, ItemStack item) {
        return this.itemValidator == null || this.itemValidator.apply(new ValidatorInfo(this, slot, item)) != false;
    }

    public static class ValidatorInfo {
        private final GuiElement element;
        private final int slot;
        private final ItemStack item;

        public ValidatorInfo(GuiElement element, int slot, ItemStack item) {
            this.item = item;
            this.slot = slot;
            this.element = element;
        }

        public GuiElement getElement() {
            return this.element;
        }

        public int getSlot() {
            return this.slot;
        }

        public ItemStack getItem() {
            return this.item;
        }
    }
}

