/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.libraries.desertwell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.desertwell.Version;

public class UpdateChecker {
    private static final String SPIGOT_API_ENDPOINT = "https://api.spigotmc.org/legacy/update.php?resource=";
    @NotNull
    private final Version currentVersion;
    private int resourceId;

    private UpdateChecker() {
        this.currentVersion = new Version();
    }

    private UpdateChecker(@NotNull Version currentVersion, int resourceId) {
        this.currentVersion = currentVersion;
        this.resourceId = resourceId;
    }

    public static UpdateChecker create(@NotNull Version currentVersion, int resourceId) {
        return new UpdateChecker(currentVersion, resourceId);
    }

    @NotNull
    public Version getCurrentVersion() {
        return this.currentVersion;
    }

    public CompletableFuture<Version> getLatestVersion() {
        return CompletableFuture.supplyAsync(() -> {
            Version version;
            InputStreamReader inputStreamReader = new InputStreamReader(new URL(SPIGOT_API_ENDPOINT + this.resourceId).openConnection().getInputStream());
            try {
                version = Version.fromString(new BufferedReader(inputStreamReader).readLine());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to fetch latest version", e);
                }
            }
            inputStreamReader.close();
            return version;
        }).exceptionally(throwable -> {
            throwable.printStackTrace();
            return new Version();
        });
    }

    public CompletableFuture<Boolean> isUpToDate() {
        return this.getLatestVersion().thenApply(latestVersion -> this.currentVersion.compareTo((Version)latestVersion) > 0);
    }
}

