/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.menu;

import java.util.List;
import java.util.function.Consumer;
import net.william278.huskhomes.gui.HuskHomesGui;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.anvilgui.AnvilGUI;
import net.william278.huskhomes.gui.libraries.inventorygui.InventoryGui;
import net.william278.huskhomes.gui.libraries.inventorygui.StaticGuiElement;
import net.william278.huskhomes.gui.menu.ListMenu;
import net.william278.huskhomes.gui.menu.Menu;
import net.william278.huskhomes.player.OnlineUser;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EditMenu<T extends SavedPosition>
extends Menu {
    private final T position;
    private final Menu.Type type;
    private final ListMenu<T> parentMenu;
    private final int pageNumber;

    @NotNull
    private static String[] getEditMenuLayout() {
        return new String[]{"aa     ab", "aundip ra", "aa     aa"};
    }

    private EditMenu(@NotNull HuskHomesGui plugin, @NotNull T position, @NotNull ListMenu<T> parentMenu, int pageNumber) {
        super(plugin, plugin.getLocales().getLocale(position instanceof Home ? "home_editor_title" : "warp_editor_title", ((SavedPosition)position).meta.name), EditMenu.getEditMenuLayout());
        this.type = position instanceof Home ? Menu.Type.HOME : Menu.Type.WARP;
        this.position = position;
        this.parentMenu = parentMenu;
        this.pageNumber = pageNumber;
    }

    public static EditMenu<Home> home(@NotNull HuskHomesGui plugin, @NotNull Home home, @NotNull ListMenu<Home> parentMenu, int pageNumber) {
        return new EditMenu<Home>(plugin, home, parentMenu, pageNumber);
    }

    public static EditMenu<Warp> warp(@NotNull HuskHomesGui plugin, @NotNull Warp warp, @NotNull ListMenu<Warp> parentMenu, int pageNumber) {
        return new EditMenu<Warp>(plugin, warp, parentMenu, pageNumber);
    }

    @Override
    protected Consumer<InventoryGui> buildMenu() {
        return menu -> {
            String string;
            Home home;
            ItemStack positionIcon = new ItemStack(this.getPositionMaterial((SavedPosition)this.position).orElse(this.plugin.getSettings().getDefaultIcon()));
            menu.setCloseAction(i -> false);
            menu.addElement(new StaticGuiElement('a', new ItemStack(switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case Menu.Type.HOME, Menu.Type.PUBLIC_HOME -> this.plugin.getSettings().getHomeEditorFillerIcon();
                case Menu.Type.WARP -> this.plugin.getSettings().getWarpEditorFillerIcon();
            }), " "));
            menu.addElement(new StaticGuiElement('b', new ItemStack(this.plugin.getSettings().getEditorBackButtonIcon()), click -> {
                HumanEntity patt3193$temp = click.getWhoClicked();
                if (patt3193$temp instanceof Player) {
                    Player player = (Player)patt3193$temp;
                    OnlineUser user = this.api.adaptUser(player);
                    this.close(user);
                    this.parentMenu.show(user);
                    this.parentMenu.setPageNumber(user, this.pageNumber);
                    this.destroy();
                }
                return true;
            }, this.plugin.getLocales().getLocale("back_button")));
            menu.addElement(new StaticGuiElement('u', new ItemStack(this.plugin.getSettings().getEditorEditLocationButtonIcon()), click -> {
                HumanEntity patt3933$temp = click.getWhoClicked();
                if (patt3933$temp instanceof Player) {
                    Player player = (Player)patt3933$temp;
                    player.performCommand(switch (this.type) {
                        default -> throw new IncompatibleClassChangeError();
                        case Menu.Type.HOME, Menu.Type.PUBLIC_HOME -> "huskhomes:edithome " + ((Home)this.position).owner.username + "." + ((SavedPosition)this.position).meta.name + " relocate";
                        case Menu.Type.WARP -> "huskhomes:editwarp " + ((SavedPosition)this.position).meta.name + " relocate";
                    });
                }
                return true;
            }, this.plugin.getLocales().getLocale("edit_location_button")));
            menu.addElement(new StaticGuiElement('n', new ItemStack(this.plugin.getSettings().getEditorEditNameButtonIcon()), click -> {
                HumanEntity patt4802$temp = click.getWhoClicked();
                if (patt4802$temp instanceof Player) {
                    Player player = (Player)patt4802$temp;
                    this.close(this.api.adaptUser(player));
                    new AnvilGUI.Builder().title(this.plugin.getLocales().getLocale("edit_name_title", ((SavedPosition)this.position).meta.name)).itemLeft(new ItemStack(positionIcon)).text(((SavedPosition)this.position).meta.name).onClose(playerInAnvil -> this.show(this.api.adaptUser(player))).onComplete(completion -> {
                        if (completion.getText() != null) {
                            if (this.position instanceof Home) {
                                player.performCommand("huskhomes:edithome " + ((Home)this.position).owner.username + "." + ((SavedPosition)this.position).meta.name + " rename " + completion.getText());
                            } else if (this.position instanceof Warp) {
                                player.performCommand("huskhomes:editwarp " + ((SavedPosition)this.position).meta.name + " rename " + completion.getText());
                            }
                            this.setPositionMaterial((SavedPosition)this.position, positionIcon.getType());
                        }
                        ((SavedPosition)this.position).meta.name = completion.getText();
                        this.close(this.api.adaptUser(player));
                        this.destroy();
                        new EditMenu<T>(this.plugin, this.position, this.parentMenu, this.pageNumber).show(this.api.adaptUser(player));
                        return List.of();
                    }).plugin((Plugin)this.plugin).open(player);
                }
                return true;
            }, this.plugin.getLocales().getLocale("edit_name_button")));
            menu.addElement(new StaticGuiElement('d', new ItemStack(this.plugin.getSettings().getEditorEditDescriptionButtonIcon()), click -> {
                HumanEntity patt7326$temp = click.getWhoClicked();
                if (patt7326$temp instanceof Player) {
                    Player player = (Player)patt7326$temp;
                    this.close(this.api.adaptUser(player));
                    new AnvilGUI.Builder().title(this.plugin.getLocales().getLocale("edit_description_title", ((SavedPosition)this.position).meta.name)).itemLeft(new ItemStack(positionIcon)).text(((SavedPosition)this.position).meta.description).onClose(playerInAnvil -> this.show(this.api.adaptUser(player))).onComplete(completion -> {
                        if (completion.getText() != null) {
                            if (this.position instanceof Home) {
                                player.performCommand("huskhomes:edithome " + ((Home)this.position).owner.username + "." + ((SavedPosition)this.position).meta.name + " description " + completion.getText());
                            } else if (this.position instanceof Warp) {
                                player.performCommand("huskhomes:editwarp " + ((SavedPosition)this.position).meta.name + " description " + completion.getText());
                            }
                            this.setPositionMaterial((SavedPosition)this.position, positionIcon.getType());
                        }
                        ((SavedPosition)this.position).meta.description = completion.getText();
                        this.show(this.api.adaptUser(player));
                        return List.of();
                    }).plugin((Plugin)this.plugin).open(player);
                }
                return true;
            }, this.plugin.getLocales().getLocale("edit_description_button")));
            T patt9418$temp = this.position;
            if (patt9418$temp instanceof Home) {
                home = (Home)patt9418$temp;
                menu.addElement(new StaticGuiElement('p', new ItemStack(this.plugin.getSettings().getEditorEditPrivacyButtonIcon()), click -> {
                    HumanEntity patt9689$temp = click.getWhoClicked();
                    if (patt9689$temp instanceof Player) {
                        Player player = (Player)patt9689$temp;
                        player.performCommand("huskhomes:edithome " + home.owner.username + "." + ((SavedPosition)this.position).meta.name + " privacy");
                    }
                    return true;
                }, this.plugin.getLocales().getLocale("edit_privacy_button")));
            }
            menu.addElement(new StaticGuiElement('r', new ItemStack(this.plugin.getSettings().getEditorDeleteButtonIcon()), click -> {
                HumanEntity patt10308$temp = click.getWhoClicked();
                if (patt10308$temp instanceof Player) {
                    Player player = (Player)patt10308$temp;
                    this.close(this.api.adaptUser(player));
                    T patt10442$temp = this.position;
                    if (patt10442$temp instanceof Home) {
                        Home home = (Home)patt10442$temp;
                        player.performCommand("huskhomes:delhome " + home.owner.username + "." + ((SavedPosition)this.position).meta.name);
                    } else {
                        T patt10642$temp = this.position;
                        if (patt10642$temp instanceof Warp) {
                            Warp warp = (Warp)patt10642$temp;
                            player.performCommand("huskhomes:delwarp " + warp.meta.name);
                        }
                    }
                }
                return true;
            }, this.plugin.getLocales().getLocale("delete_button")));
            ItemStack itemStack = new ItemStack(Material.OAK_SIGN);
            String[] stringArray = new String[6];
            stringArray[0] = this.plugin.getLocales().getLocale("item_info_name", ((SavedPosition)this.position).meta.name);
            stringArray[1] = this.plugin.getLocales().getLocale("item_info_description", ((SavedPosition)this.position).meta.description);
            stringArray[2] = this.plugin.getLocales().getLocale("item_info_world", ((SavedPosition)this.position).world.name);
            stringArray[3] = this.plugin.getLocales().getLocale("item_info_server", ((SavedPosition)this.position).server.name);
            stringArray[4] = this.plugin.getLocales().getLocale("item_info_coordinates", Integer.toString((int)Math.floor(((SavedPosition)this.position).x)), Integer.toString((int)Math.floor(((SavedPosition)this.position).y)), Integer.toString((int)Math.floor(((SavedPosition)this.position).z)));
            T patt11815$temp = this.position;
            if (patt11815$temp instanceof Home) {
                home = (Home)patt11815$temp;
                string = this.plugin.getLocales().getLocale("home_owner_name", home.owner.username);
            } else {
                string = "";
            }
            stringArray[5] = string;
            menu.addElement(new StaticGuiElement('i', itemStack, stringArray));
        };
    }
}

