/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.libraries.boostedyaml.boostedyaml.engine;

import java.util.Map;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.annotations.Nullable;
import net.william278.huskhomes.gui.libraries.boostedyaml.boostedyaml.YamlDocument;
import net.william278.huskhomes.gui.libraries.boostedyaml.boostedyaml.block.Block;
import net.william278.huskhomes.gui.libraries.boostedyaml.boostedyaml.block.Comments;
import net.william278.huskhomes.gui.libraries.boostedyaml.boostedyaml.block.implementation.Section;
import net.william278.huskhomes.gui.libraries.boostedyaml.boostedyaml.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import net.william278.huskhomes.gui.libraries.boostedyaml.boostedyaml.libs.org.snakeyaml.engine.v2.api.RepresentToNode;
import net.william278.huskhomes.gui.libraries.boostedyaml.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import net.william278.huskhomes.gui.libraries.boostedyaml.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import net.william278.huskhomes.gui.libraries.boostedyaml.boostedyaml.libs.org.snakeyaml.engine.v2.representer.StandardRepresenter;
import net.william278.huskhomes.gui.libraries.boostedyaml.boostedyaml.settings.general.GeneralSettings;

public class ExtendedRepresenter
extends StandardRepresenter {
    private final GeneralSettings generalSettings;

    public ExtendedRepresenter(@NotNull GeneralSettings generalSettings, @NotNull DumpSettings dumpSettings) {
        super(dumpSettings);
        this.generalSettings = generalSettings;
        RepresentSection representSection = new RepresentSection();
        RepresentSerializable representSerializable = new RepresentSerializable();
        this.representers.put(Section.class, representSection);
        this.representers.put(YamlDocument.class, representSection);
        this.representers.put(Enum.class, new RepresentEnum());
        for (Class<?> clazz : generalSettings.getSerializer().getSupportedClasses()) {
            this.representers.put(clazz, representSerializable);
        }
        for (Class<?> clazz : generalSettings.getSerializer().getSupportedParentClasses()) {
            this.parentClassRepresenters.put(clazz, representSerializable);
        }
    }

    @NotNull
    public Node applyKeyComments(@Nullable Block<?> block, @NotNull Node node) {
        if (block != null) {
            node.setBlockComments(Comments.get(block, Comments.NodeType.KEY, Comments.Position.BEFORE));
            node.setInLineComments(Comments.get(block, Comments.NodeType.KEY, Comments.Position.INLINE));
            node.setEndComments(Comments.get(block, Comments.NodeType.KEY, Comments.Position.AFTER));
        }
        return node;
    }

    @NotNull
    public Node applyValueComments(@Nullable Block<?> block, @NotNull Node node) {
        if (block != null) {
            node.setBlockComments(Comments.get(block, Comments.NodeType.VALUE, Comments.Position.BEFORE));
            node.setInLineComments(Comments.get(block, Comments.NodeType.VALUE, Comments.Position.INLINE));
            node.setEndComments(Comments.get(block, Comments.NodeType.VALUE, Comments.Position.AFTER));
        }
        return node;
    }

    @Override
    protected NodeTuple representMappingEntry(Map.Entry<?, ?> entry) {
        Block block = entry.getValue() instanceof Block ? (Block)entry.getValue() : null;
        Node key = this.applyKeyComments(block, this.representData(entry.getKey()));
        Node value = this.applyValueComments(block, this.representData(block == null ? entry.getValue() : block.getStoredValue()));
        return new NodeTuple(key, value);
    }

    private class RepresentEnum
    implements RepresentToNode {
        private RepresentEnum() {
        }

        @Override
        public Node representData(Object data) {
            return ExtendedRepresenter.this.representData(((Enum)data).name());
        }
    }

    private class RepresentSection
    implements RepresentToNode {
        private RepresentSection() {
        }

        @Override
        public Node representData(Object data) {
            Section section = (Section)data;
            return ExtendedRepresenter.this.applyKeyComments(section, ExtendedRepresenter.this.representData(section.getStoredValue()));
        }
    }

    private class RepresentSerializable
    implements RepresentToNode {
        private RepresentSerializable() {
        }

        @Override
        public Node representData(Object data) {
            Map<Object, Object> serialized = ExtendedRepresenter.this.generalSettings.getSerializer().serialize(data, ExtendedRepresenter.this.generalSettings.getDefaultMapSupplier());
            return ExtendedRepresenter.this.representData(serialized == null ? data : serialized);
        }
    }
}

