/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.libraries.inventorygui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiElement;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiElementGroup;
import net.william278.huskhomes.gui.libraries.inventorygui.InventoryGui;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DynamicGuiElement
extends GuiElement {
    private Function<HumanEntity, GuiElement> query;
    private Map<UUID, CacheEntry> cachedElements = new HashMap<UUID, CacheEntry>();

    public DynamicGuiElement(char slotChar, Supplier<GuiElement> query) {
        this(slotChar, (HumanEntity h) -> (GuiElement)query.get());
    }

    public DynamicGuiElement(char slotChar, Function<HumanEntity, GuiElement> query) {
        super(slotChar);
        this.query = query;
    }

    public void update() {
        for (UUID playerId : new ArrayList<UUID>(this.cachedElements.keySet())) {
            Player p = this.gui.getPlugin().getServer().getPlayer(playerId);
            if (p != null && p.isOnline()) {
                this.update((HumanEntity)p);
                continue;
            }
            this.cachedElements.remove(playerId);
        }
    }

    public CacheEntry update(HumanEntity player) {
        CacheEntry cacheEntry = new CacheEntry(this.queryElement(player));
        if (cacheEntry.element instanceof DynamicGuiElement) {
            ((DynamicGuiElement)cacheEntry.element).update(player);
        } else if (cacheEntry.element instanceof GuiElementGroup) {
            InventoryGui.updateElements(player, ((GuiElementGroup)cacheEntry.element).getElements());
        }
        this.cachedElements.put(player.getUniqueId(), cacheEntry);
        return cacheEntry;
    }

    @Override
    public void setGui(InventoryGui gui) {
        super.setGui(gui);
    }

    @Override
    public ItemStack getItem(HumanEntity who, int slot) {
        GuiElement element = this.getCachedElement(who);
        return element != null ? element.getItem(who, slot) : null;
    }

    @Override
    public GuiElement.Action getAction(HumanEntity who) {
        GuiElement element = this.getCachedElement(who);
        return element != null ? element.getAction(who) : null;
    }

    public Function<HumanEntity, GuiElement> getQuery() {
        return this.query;
    }

    public void setQuery(Function<HumanEntity, GuiElement> query) {
        this.query = query;
    }

    public GuiElement queryElement(HumanEntity who) {
        GuiElement element = this.getQuery().apply(who);
        if (element != null) {
            element.setGui(this.gui);
            element.setSlots(this.slots);
        }
        return element;
    }

    public GuiElement getCachedElement(HumanEntity who) {
        CacheEntry cached = this.cachedElements.get(who.getUniqueId());
        if (cached == null) {
            cached = this.update(who);
        }
        return cached.getElement();
    }

    public GuiElement removeCachedElement(HumanEntity who) {
        CacheEntry cached = this.cachedElements.remove(who.getUniqueId());
        return cached != null ? cached.getElement() : null;
    }

    public long getLastCached(HumanEntity who) {
        CacheEntry cached = this.cachedElements.get(who.getUniqueId());
        return cached != null ? cached.getCreated() : -1L;
    }

    public class CacheEntry {
        private final GuiElement element;
        private final long created = System.currentTimeMillis();

        CacheEntry(GuiElement element) {
            this.element = element;
        }

        public GuiElement getElement() {
            return this.element;
        }

        public long getCreated() {
            return this.created;
        }
    }
}

