/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.menu;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.william278.huskhomes.gui.HuskHomesGui;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.inventorygui.DynamicGuiElement;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiElement;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiElementGroup;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiPageElement;
import net.william278.huskhomes.gui.libraries.inventorygui.InventoryGui;
import net.william278.huskhomes.gui.libraries.inventorygui.StaticGuiElement;
import net.william278.huskhomes.gui.menu.EditMenu;
import net.william278.huskhomes.gui.menu.Menu;
import net.william278.huskhomes.player.OnlineUser;
import net.william278.huskhomes.player.User;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.util.Permission;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ListMenu<T extends SavedPosition>
extends Menu {
    private final List<T> positions;
    private final Menu.Type type;
    private final int pageNumber = 1;

    @NotNull
    public static ListMenu<Home> homes(@NotNull HuskHomesGui plugin, @NotNull List<Home> homes, @NotNull User owner) {
        return new ListMenu<Home>(plugin, homes, Menu.Type.HOME, plugin.getLocales().getLocale("homes_menu_title", owner.username));
    }

    @NotNull
    public static ListMenu<Home> publicHomes(@NotNull HuskHomesGui plugin, @NotNull List<Home> homes) {
        return new ListMenu<Home>(plugin, homes, Menu.Type.PUBLIC_HOME, plugin.getLocales().getLocale("public_homes_menu_title"));
    }

    @NotNull
    public static ListMenu<Warp> warps(@NotNull HuskHomesGui plugin, @NotNull List<Warp> warps) {
        return new ListMenu<Warp>(plugin, warps, Menu.Type.WARP, plugin.getLocales().getLocale("warps_menu_title"));
    }

    private ListMenu(@NotNull HuskHomesGui plugin, @NotNull List<T> positions, @NotNull Menu.Type type, @NotNull String title) {
        super(plugin, title, ListMenu.getMenuLayout(plugin));
        this.positions = positions;
        this.type = type;
    }

    @NotNull
    private static String[] getMenuLayout(@NotNull HuskHomesGui plugin) {
        return Arrays.copyOfRange(new String[]{"ppppppppp", "ppppppppp", "ppppppppp", "ppppppppp", "ppppppppp", "bl  i  ne"}, 6 - plugin.getSettings().getMenuSize(), 6);
    }

    @Override
    protected Consumer<InventoryGui> buildMenu() {
        return menu -> {
            menu.setFiller(new ItemStack(this.type.getFillerMaterial(this.plugin.getSettings()), 1));
            menu.addElement(this.getPositionGroup(this.plugin, this.positions));
            menu.addElement(new GuiPageElement('b', new ItemStack(this.plugin.getSettings().getPaginateFirstPage()), GuiPageElement.PageAction.FIRST, this.plugin.getLocales().getLocale("pagination_first_page")));
            menu.addElement(new GuiPageElement('l', new ItemStack(this.plugin.getSettings().getPaginatePreviousPage()), GuiPageElement.PageAction.PREVIOUS, this.plugin.getLocales().getLocale("pagination_previous_page")));
            menu.addElement(new GuiPageElement('n', new ItemStack(this.plugin.getSettings().getPaginateNextPage()), GuiPageElement.PageAction.NEXT, this.plugin.getLocales().getLocale("pagination_next_page")));
            menu.addElement(new GuiPageElement('e', new ItemStack(this.plugin.getSettings().getPaginateLastPage()), GuiPageElement.PageAction.LAST, this.plugin.getLocales().getLocale("pagination_last_page")));
            menu.setPageNumber(1);
            if (this.plugin.getSettings().doShowMenuControls()) {
                menu.addElement(new StaticGuiElement('i', new ItemStack(this.plugin.getSettings().getControlsIcon()), this.plugin.getLocales().getLocale("menu_controls_title"), this.plugin.getLocales().getLocale("menu_controls_details")));
            }
        };
    }

    @NotNull
    private GuiElementGroup getPositionGroup(@NotNull HuskHomesGui plugin, @NotNull List<T> positions) {
        GuiElementGroup group = new GuiElementGroup('p', new GuiElement[0]);
        positions.forEach(position -> group.addElement(this.getPositionButton(plugin, (SavedPosition)position)));
        return group;
    }

    @NotNull
    private DynamicGuiElement getPositionButton(@NotNull HuskHomesGui plugin, @NotNull SavedPosition position) {
        return new DynamicGuiElement('e', viewer -> {
            String string;
            ItemStack itemStack = new ItemStack(this.getPositionMaterial(position).orElse(plugin.getSettings().getDefaultIcon()));
            GuiElement.Action action = click -> {
                HumanEntity patt5197$temp = click.getWhoClicked();
                if (patt5197$temp instanceof Player) {
                    Player player = (Player)patt5197$temp;
                    OnlineUser user = this.api.adaptUser(player);
                    switch (click.getType()) {
                        case LEFT: {
                            ItemStack newItem = player.getItemOnCursor();
                            if (newItem.getType() == Material.AIR) {
                                this.close(user);
                                this.destroy();
                                this.api.teleportBuilder(user).setTarget((Position)position).toTimedTeleport().thenAccept(Teleport::execute);
                                return true;
                            }
                            if (!player.hasPermission(Permission.COMMAND_EDIT_HOME.node) && !player.hasPermission(Permission.COMMAND_EDIT_HOME_OTHER.node)) {
                                return true;
                            }
                            this.setPositionMaterial(position, newItem.getType()).thenRun(() -> player.sendMessage(plugin.getLocales().getLocale("updated_icon", position.meta.name)));
                            click.getGui().draw();
                            break;
                        }
                        case RIGHT: 
                        case DROP: {
                            Home home;
                            switch (this.type) {
                                case WARP: {
                                    if (player.hasPermission(Permission.COMMAND_EDIT_WARP.node)) break;
                                    return true;
                                }
                                case PUBLIC_HOME: 
                                case HOME: {
                                    if (!(position instanceof Home)) break;
                                    home = (Home)position;
                                    if (!player.hasPermission(Permission.COMMAND_EDIT_HOME.node)) {
                                        return true;
                                    }
                                    if (player.getUniqueId().equals(home.owner.uuid) || player.hasPermission(Permission.COMMAND_EDIT_HOME_OTHER.node)) break;
                                    return true;
                                }
                            }
                            if (position instanceof Home) {
                                home = (Home)position;
                                EditMenu.home(plugin, home, this, this.getPageNumber(user)).show(user);
                                break;
                            }
                            if (!(position instanceof Warp)) break;
                            Warp warp = (Warp)position;
                            EditMenu.warp(plugin, warp, this, this.getPageNumber(user)).show(user);
                        }
                    }
                }
                return true;
            };
            String[] stringArray = new String[6];
            stringArray[0] = plugin.getLocales().getLocale("item_name", position.meta.name);
            String string2 = stringArray[1] = !position.meta.description.isBlank() ? plugin.getLocales().getLocale("item_description", position.meta.description) : plugin.getLocales().getLocale("item_description_blank");
            if (position instanceof Home) {
                Home home = (Home)position;
                string = plugin.getLocales().getLocale("home_owner_name", home.owner.username);
            } else {
                string = "";
            }
            stringArray[2] = string;
            stringArray[3] = plugin.getLocales().getLocale("item_controls_left_click");
            stringArray[4] = plugin.getLocales().getLocale("item_controls_right_click");
            stringArray[5] = plugin.getLocales().getLocale("item_controls_shift_click");
            return new StaticGuiElement('e', itemStack, action, stringArray);
        });
    }
}

