/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui;

import java.util.Objects;
import java.util.logging.Level;
import net.william278.huskhomes.gui.HuskHomesGuiPlugin;
import net.william278.huskhomes.gui.command.HuskHomesGuiCommand;
import net.william278.huskhomes.gui.config.Locales;
import net.william278.huskhomes.gui.config.Settings;
import net.william278.huskhomes.gui.libraries.adventure.platform.AudienceProvider;
import net.william278.huskhomes.gui.libraries.adventure.platform.bukkit.BukkitAudiences;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.desertwell.Version;
import net.william278.huskhomes.gui.listener.ListListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HuskHomesGui
extends JavaPlugin
implements HuskHomesGuiPlugin {
    private BukkitAudiences adventure;
    private Settings settings;
    private Locales locales;

    public void onEnable() {
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.reloadConfigFiles();
        this.getServer().getPluginManager().registerEvents((Listener)new ListListener(this), (Plugin)this);
        Objects.requireNonNull(this.getCommand("huskhomesgui")).setExecutor((CommandExecutor)new HuskHomesGuiCommand(this));
        this.getLogger().log(Level.INFO, "Successfully enabled HuskHomes v" + this.getDescription().getVersion());
    }

    public void reloadConfigFiles() {
        this.settings = this.loadSettings();
        this.locales = this.loadLocales();
    }

    @Override
    @NotNull
    public AudienceProvider getAudiences() {
        return this.adventure;
    }

    @Override
    @NotNull
    public Version getPluginVersion() {
        return Version.fromString(this.getDescription().getVersion(), "-");
    }

    @Override
    @NotNull
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    @NotNull
    public Locales getLocales() {
        return this.locales;
    }
}

