/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.menu;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.william278.huskhomes.api.HuskHomesAPI;
import net.william278.huskhomes.gui.HuskHomesGui;
import net.william278.huskhomes.gui.config.Settings;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiElement;
import net.william278.huskhomes.gui.libraries.inventorygui.InventoryGui;
import net.william278.huskhomes.player.OnlineUser;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.PositionMeta;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.SavedPositionManager;
import net.william278.huskhomes.position.Warp;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class Menu {
    private static final String TAG_KEY = "huskhomesgui:icon";
    protected final HuskHomesGui plugin;
    protected final HuskHomesAPI api;
    private final InventoryGui gui;

    protected Menu(@NotNull HuskHomesGui plugin, @NotNull String title, @NotNull String[] layout) {
        this.plugin = plugin;
        this.api = HuskHomesAPI.getInstance();
        this.gui = new InventoryGui((JavaPlugin)plugin, title, layout, new GuiElement[0]);
    }

    protected abstract Consumer<InventoryGui> buildMenu();

    public final void show(@NotNull OnlineUser user) {
        this.buildMenu().accept(this.gui);
        this.gui.show((HumanEntity)this.api.getPlayer(user));
    }

    public final void setPageNumber(@NotNull OnlineUser user, int pageNumber) {
        this.gui.setPageNumber((HumanEntity)this.api.getPlayer(user), pageNumber);
    }

    public final int getPageNumber(@NotNull OnlineUser user) {
        return this.gui.getPageNumber((HumanEntity)this.api.getPlayer(user));
    }

    public final void close(@NotNull OnlineUser user) {
        this.gui.close((HumanEntity)this.api.getPlayer(user));
    }

    public final void destroy() {
        this.gui.destroy();
    }

    protected Optional<Material> getPositionMaterial(@NotNull SavedPosition position) {
        if (position.meta.tags.containsKey(TAG_KEY)) {
            return Optional.ofNullable(Material.matchMaterial((String)((String)position.meta.tags.get(TAG_KEY))));
        }
        return Optional.empty();
    }

    protected CompletableFuture<SavedPositionManager.SaveResult> setPositionMaterial(@NotNull SavedPosition position, @NotNull Material material) {
        PositionMeta meta = position.meta;
        meta.tags.put(TAG_KEY, material.getKey().toString());
        if (position instanceof Warp) {
            Warp warp = (Warp)position;
            return this.api.updateWarpMeta(warp, meta);
        }
        if (position instanceof Home) {
            Home home = (Home)position;
            return this.api.updateHomeMeta(home, meta);
        }
        throw new IllegalArgumentException("Position must be a warp or home");
    }

    protected static enum Type {
        HOME,
        PUBLIC_HOME,
        WARP;


        public Material getFillerMaterial(@NotNull Settings settings) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HOME -> settings.getHomesFillerItem();
                case PUBLIC_HOME -> settings.getPublicHomesFillerItem();
                case WARP -> settings.getWarpsFillerItem();
            };
        }
    }
}

