/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.menu;

import java.util.List;
import java.util.function.Consumer;
import net.william278.huskhomes.gui.HuskHomesGui;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.anvilgui.AnvilGUI;
import net.william278.huskhomes.gui.libraries.inventorygui.InventoryGui;
import net.william278.huskhomes.gui.libraries.inventorygui.StaticGuiElement;
import net.william278.huskhomes.gui.menu.ListMenu;
import net.william278.huskhomes.gui.menu.Menu;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.ValidationException;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EditMenu<T extends SavedPosition>
extends Menu {
    private final T position;
    private final Menu.Type type;
    private final ListMenu<T> parentMenu;
    private final int pageNumber;

    @NotNull
    private static String[] getEditMenuLayout() {
        return new String[]{"aa     ab", "aundip ra", "aa     aa"};
    }

    private EditMenu(@NotNull HuskHomesGui plugin, @NotNull T position, @NotNull ListMenu<T> parentMenu, int pageNumber) {
        super(plugin, plugin.getLocales().getLocale(position instanceof Home ? "home_editor_title" : "warp_editor_title", position.getName()), EditMenu.getEditMenuLayout());
        this.type = position instanceof Home ? Menu.Type.HOME : Menu.Type.WARP;
        this.position = position;
        this.parentMenu = parentMenu;
        this.pageNumber = pageNumber;
    }

    public static EditMenu<Home> home(@NotNull HuskHomesGui plugin, @NotNull Home home, @NotNull ListMenu<Home> parentMenu, int pageNumber) {
        return new EditMenu<Home>(plugin, home, parentMenu, pageNumber);
    }

    public static EditMenu<Warp> warp(@NotNull HuskHomesGui plugin, @NotNull Warp warp, @NotNull ListMenu<Warp> parentMenu, int pageNumber) {
        return new EditMenu<Warp>(plugin, warp, parentMenu, pageNumber);
    }

    @Override
    protected Consumer<InventoryGui> buildMenu() {
        return menu -> {
            String string;
            Home home;
            ItemStack positionIcon = new ItemStack(this.getPositionMaterial((SavedPosition)this.position).orElse(this.plugin.getSettings().getDefaultIcon()));
            menu.setCloseAction(i -> false);
            menu.addElement(new StaticGuiElement('a', new ItemStack(switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case Menu.Type.HOME, Menu.Type.PUBLIC_HOME -> this.plugin.getSettings().getHomeEditorFillerIcon();
                case Menu.Type.WARP -> this.plugin.getSettings().getWarpEditorFillerIcon();
            }), " "));
            menu.addElement(new StaticGuiElement('b', new ItemStack(this.plugin.getSettings().getEditorBackButtonIcon()), click -> {
                HumanEntity patt3170$temp = click.getWhoClicked();
                if (patt3170$temp instanceof Player) {
                    Player player = (Player)patt3170$temp;
                    OnlineUser user = this.api.adaptUser(player);
                    this.close(user);
                    this.parentMenu.show(user);
                    this.parentMenu.setPageNumber(user, this.pageNumber);
                    this.destroy();
                }
                return true;
            }, this.plugin.getLocales().getLocale("back_button")));
            menu.addElement(new StaticGuiElement('u', new ItemStack(this.plugin.getSettings().getEditorEditLocationButtonIcon()), click -> {
                HumanEntity patt3895$temp = click.getWhoClicked();
                if (patt3895$temp instanceof Player) {
                    Player player = (Player)patt3895$temp;
                    OnlineUser onlineUser = this.api.adaptUser(player);
                    try {
                        T patt4083$temp = this.position;
                        if (patt4083$temp instanceof Home) {
                            Home home = (Home)patt4083$temp;
                            this.api.relocateHome(home, onlineUser.getPosition());
                        } else {
                            T patt4245$temp = this.position;
                            if (patt4245$temp instanceof Warp) {
                                Warp warp = (Warp)patt4245$temp;
                                this.api.relocateWarp(warp, onlineUser.getPosition());
                            }
                        }
                    }
                    catch (ValidationException e) {
                        return true;
                    }
                }
                return true;
            }, this.plugin.getLocales().getLocale("edit_location_button")));
            menu.addElement(new StaticGuiElement('n', new ItemStack(this.plugin.getSettings().getEditorEditNameButtonIcon()), click -> {
                HumanEntity patt4954$temp = click.getWhoClicked();
                if (patt4954$temp instanceof Player) {
                    Player player = (Player)patt4954$temp;
                    this.close(this.api.adaptUser(player));
                    new AnvilGUI.Builder().title(this.plugin.getLocales().getLocale("edit_name_title", this.position.getName())).itemLeft(new ItemStack(positionIcon)).text(this.position.getName()).onClose(playerInAnvil -> this.show(this.api.adaptUser(player))).onComplete(completion -> {
                        if (completion.getText() != null) {
                            try {
                                T patt5695$temp = this.position;
                                if (patt5695$temp instanceof Home) {
                                    Home home = (Home)patt5695$temp;
                                    this.api.renameHome(home, completion.getText());
                                } else {
                                    T patt5883$temp = this.position;
                                    if (patt5883$temp instanceof Warp) {
                                        Warp warp = (Warp)patt5883$temp;
                                        this.api.renameWarp(warp, completion.getText());
                                    }
                                }
                            }
                            catch (ValidationException e) {
                                return List.of();
                            }
                        }
                        this.position.getMeta().setName(completion.getText());
                        this.close(this.api.adaptUser(player));
                        this.destroy();
                        new EditMenu<T>(this.plugin, this.position, this.parentMenu, this.pageNumber).show(this.api.adaptUser(player));
                        return List.of();
                    }).plugin((Plugin)this.plugin).open(player);
                }
                return true;
            }, this.plugin.getLocales().getLocale("edit_name_button")));
            menu.addElement(new StaticGuiElement('d', new ItemStack(this.plugin.getSettings().getEditorEditDescriptionButtonIcon()), click -> {
                HumanEntity patt7333$temp = click.getWhoClicked();
                if (patt7333$temp instanceof Player) {
                    Player player = (Player)patt7333$temp;
                    this.close(this.api.adaptUser(player));
                    new AnvilGUI.Builder().title(this.plugin.getLocales().getLocale("edit_description_title", this.position.getName())).itemLeft(new ItemStack(positionIcon)).text(this.position.getMeta().getDescription()).onClose(playerInAnvil -> this.show(this.api.adaptUser(player))).onComplete(completion -> {
                        if (completion.getText() != null) {
                            try {
                                T patt8098$temp = this.position;
                                if (patt8098$temp instanceof Home) {
                                    Home home = (Home)patt8098$temp;
                                    this.api.setHomeDescription(home, completion.getText());
                                } else {
                                    T patt8294$temp = this.position;
                                    if (patt8294$temp instanceof Warp) {
                                        Warp warp = (Warp)patt8294$temp;
                                        this.api.setWarpDescription(warp, completion.getText());
                                    }
                                }
                            }
                            catch (ValidationException e) {
                                return List.of();
                            }
                        }
                        this.position.getMeta().setDescription(completion.getText());
                        this.show(this.api.adaptUser(player));
                        return List.of();
                    }).plugin((Plugin)this.plugin).open(player);
                }
                return true;
            }, this.plugin.getLocales().getLocale("edit_description_button")));
            T patt9303$temp = this.position;
            if (patt9303$temp instanceof Home) {
                home = (Home)patt9303$temp;
                menu.addElement(new StaticGuiElement('p', new ItemStack(this.plugin.getSettings().getEditorEditPrivacyButtonIcon()), click -> {
                    if (click.getWhoClicked() instanceof Player) {
                        try {
                            this.api.setHomePrivacy(home, !home.isPublic());
                        }
                        catch (ValidationException e) {
                            return true;
                        }
                    }
                    return true;
                }, this.plugin.getLocales().getLocale("edit_privacy_button")));
            }
            menu.addElement(new StaticGuiElement('r', new ItemStack(this.plugin.getSettings().getEditorDeleteButtonIcon()), click -> {
                HumanEntity patt10297$temp = click.getWhoClicked();
                if (patt10297$temp instanceof Player) {
                    Player player = (Player)patt10297$temp;
                    this.close(this.api.adaptUser(player));
                    try {
                        T patt10467$temp = this.position;
                        if (patt10467$temp instanceof Home) {
                            Home home = (Home)patt10467$temp;
                            this.api.deleteHome(home);
                        } else {
                            T patt10601$temp = this.position;
                            if (patt10601$temp instanceof Warp) {
                                Warp warp = (Warp)patt10601$temp;
                                this.api.deleteWarp(warp);
                            }
                        }
                    }
                    catch (ValidationException e) {
                        return true;
                    }
                }
                return true;
            }, this.plugin.getLocales().getLocale("delete_button")));
            ItemStack itemStack = new ItemStack(Material.OAK_SIGN);
            String[] stringArray = new String[6];
            stringArray[0] = this.plugin.getLocales().getLocale("item_info_name", this.position.getName());
            stringArray[1] = this.plugin.getLocales().getLocale("item_info_description", this.position.getMeta().getDescription());
            stringArray[2] = this.plugin.getLocales().getLocale("item_info_world", this.position.getWorld().getName());
            stringArray[3] = this.plugin.getLocales().getLocale("item_info_server", this.position.getServer());
            stringArray[4] = this.plugin.getLocales().getLocale("item_info_coordinates", Integer.toString((int)Math.floor(this.position.getX())), Integer.toString((int)Math.floor(this.position.getY())), Integer.toString((int)Math.floor(this.position.getZ())));
            T patt11895$temp = this.position;
            if (patt11895$temp instanceof Home) {
                home = (Home)patt11895$temp;
                string = this.plugin.getLocales().getLocale("home_owner_name", home.getOwner().getUsername());
            } else {
                string = "";
            }
            stringArray[5] = string;
            menu.addElement(new StaticGuiElement('i', itemStack, stringArray));
        };
    }
}

