/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.william278.huskhomes.gui.libraries.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.william278.huskhomes.gui.libraries.annotaml.YamlFile;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.commons.text.StringEscapeUtils;
import net.william278.huskhomes.gui.libraries.minedown.adventure.MineDown;

@YamlFile(header="\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503     HuskHomesGui Locales     \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2517\u2578 Formatted in MineDown: https://github.com/Phoenix616/MineDown", rootedMap=true)
public class Locales {
    public Map<String, String> rawLocales = new HashMap<String, String>();

    private Locales() {
    }

    public Optional<String> getRawLocale(@NotNull String localeId) {
        return Optional.ofNullable(this.rawLocales.get(localeId)).map(StringEscapeUtils::unescapeJava);
    }

    public Optional<String> getRawLocale(@NotNull String localeId, String ... replacements) {
        return this.getRawLocale(localeId).map(locale -> this.applyReplacements((String)locale, replacements));
    }

    public String getLocale(@NotNull String localeId) {
        return this.getLocale(localeId, new String[0]);
    }

    public String getLocale(@NotNull String localeId, String ... replacements) {
        return this.getRawLocale(localeId, (String[])Arrays.stream(replacements).map(Locales::escapeText).toArray(String[]::new)).map(MineDown::new).map(MineDown::toComponent).map(LegacyComponentSerializer.builder().build()::serialize).orElse("");
    }

    @NotNull
    private String applyReplacements(@NotNull String rawLocale, String ... replacements) {
        int replacementIndexer = 1;
        for (String replacement : replacements) {
            String replacementString = "%" + replacementIndexer + "%";
            rawLocale = rawLocale.replace(replacementString, replacement);
            ++replacementIndexer;
        }
        return rawLocale;
    }

    @NotNull
    public static String escapeText(@NotNull String string) {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            boolean isEvent;
            char c = string.charAt(i);
            boolean isEscape = c == '\\';
            boolean isColorCode = i + 1 < string.length() && (c == '\u00a7' || c == '&');
            boolean bl = isEvent = c == '[' || c == ']' || c == '(' || c == ')';
            if (isEscape || isColorCode || isEvent) {
                value.append('\\');
            }
            value.append(c);
        }
        return value.toString();
    }
}

