/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.libraries.desertwell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.annotations.Nullable;
import net.william278.huskhomes.gui.libraries.desertwell.Version;
import net.william278.huskhomes.gui.libraries.minedown.adventure.MineDown;
import net.william278.huskhomes.gui.libraries.minedown.adventure.Util;

public class AboutMenu {
    @NotNull
    private final String title;
    @Nullable
    private Version version;
    @Nullable
    private String description;
    @NotNull
    private final Map<String, List<Credit>> attributions;
    @NotNull
    private final List<Link> buttons;

    private AboutMenu() {
        this.title = "";
        this.buttons = new ArrayList<Link>();
        this.attributions = new LinkedHashMap<String, List<Credit>>();
    }

    private AboutMenu(@NotNull String title) {
        this.title = title;
        this.buttons = new ArrayList<Link>();
        this.attributions = new LinkedHashMap<String, List<Credit>>();
    }

    @NotNull
    public static AboutMenu create(@NotNull String title) {
        return new AboutMenu(title);
    }

    @NotNull
    public AboutMenu withDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @NotNull
    public AboutMenu withVersion(@NotNull Version version) {
        this.version = version;
        return this;
    }

    @NotNull
    public AboutMenu addAttribution(@NotNull String category, Credit ... credits) {
        ArrayList<Credit> creditList = new ArrayList<Credit>(Arrays.asList(credits));
        this.attributions.putIfAbsent(category, new ArrayList());
        this.attributions.get(category).addAll(creditList);
        return this;
    }

    @NotNull
    public AboutMenu addButtons(Link ... links) {
        this.buttons.addAll(Arrays.asList(links));
        return this;
    }

    @NotNull
    public MineDown toMineDown() {
        StringJoiner menu = new StringJoiner("\n").add("[" + AboutMenu.escapeMineDown(this.title) + "](#00fb9a bold)" + (String)(this.version != null ? " [| v" + AboutMenu.escapeMineDown(this.version.toString()) + "](#00fb9a)" : ""));
        if (this.description != null) {
            menu.add("[" + AboutMenu.escapeMineDown(this.description) + "](gray)");
        }
        if (!this.attributions.isEmpty()) {
            menu.add("");
        }
        for (Map.Entry<String, List<Credit>> entry : this.attributions.entrySet()) {
            StringJoiner creditJoiner = new StringJoiner(", ");
            for (Credit credit : entry.getValue()) {
                creditJoiner.add("[" + credit.name + "](" + credit.color + (String)(credit.description != null ? " show_text=&7" + AboutMenu.escapeMineDown(credit.description) : "") + (String)(credit.url != null ? " open_url=" + AboutMenu.escapeMineDown(credit.url) : "") + ")");
            }
            if (creditJoiner.toString().isBlank()) continue;
            menu.add("[\u2022 " + entry.getKey() + ":](white) " + creditJoiner);
        }
        if (!this.buttons.isEmpty()) {
            StringJoiner buttonsJoiner = new StringJoiner("   ");
            for (Link link : this.buttons) {
                buttonsJoiner.add("[[" + (String)(link.icon != null ? link.icon + " " : "") + AboutMenu.escapeMineDown(link.text) + "\u2026]](" + link.color + " show_text=&7Click to open link open_url=" + AboutMenu.escapeMineDown(link.url) + ")");
            }
            menu.add("").add("[Links:](gray) " + buttonsJoiner);
        }
        return new MineDown(menu.toString()).replace(new String[0]);
    }

    @NotNull
    public String toString() {
        StringJoiner menu = new StringJoiner("\n").add(this.title + (String)(this.version != null ? " | Version " + this.version : ""));
        if (this.description != null) {
            menu.add(this.description);
        }
        if (!this.attributions.entrySet().isEmpty()) {
            menu.add("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        }
        for (Map.Entry<String, List<Credit>> entry : this.attributions.entrySet()) {
            StringJoiner creditJoiner = new StringJoiner(", ");
            for (Credit credit : entry.getValue()) {
                creditJoiner.add(credit.name + (String)(credit.description != null ? " (" + credit.description + ")" : ""));
            }
            if (creditJoiner.toString().isBlank()) continue;
            menu.add("- " + entry.getKey() + ": " + creditJoiner);
        }
        if (!this.buttons.isEmpty()) {
            menu.add("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            for (Link link : this.buttons) {
                menu.add("- " + link.text + ": " + link.url);
            }
        }
        return menu.toString();
    }

    @NotNull
    private static String escapeMineDown(@NotNull String string) {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            boolean isFormatting;
            char c = string.charAt(i);
            boolean isEscape = c == '\\';
            boolean isColorCode = i + 1 < string.length() && (c == '\u00a7' || c == '&');
            boolean isEvent = c == '[' || c == ']' || c == '(' || c == ')';
            boolean bl = isFormatting = (c == '_' || c == '*' || c == '~' || c == '?' || c == '#') && Util.isDouble(string, i);
            if (isEscape || isColorCode || isEvent || isFormatting) {
                value.append('\\');
            }
            value.append(c);
        }
        return value.toString();
    }

    public static class Credit {
        @NotNull
        private final String name;
        @Nullable
        private String description;
        @Nullable
        private String url;
        @NotNull
        private String color = "gray";

        private Credit(@NotNull String name) {
            this.name = name;
        }

        public static Credit of(@NotNull String name) {
            return new Credit(name);
        }

        public Credit withDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Credit withUrl(@Nullable String url) {
            this.url = url;
            return this;
        }

        public Credit withColor(@NotNull String color) {
            this.color = color;
            return this;
        }
    }

    public static class Link {
        @NotNull
        private String text = "Link";
        @NotNull
        private String color = "#00fb9a";
        @Nullable
        private String icon;
        @NotNull
        private final String url;

        private Link(@NotNull String url) {
            this.url = url;
        }

        public static Link of(@NotNull String url) {
            return new Link(url);
        }

        public Link withText(@NotNull String text) {
            this.text = text;
            return this;
        }

        public Link withIcon(@NotNull String icon) {
            this.icon = icon;
            return this;
        }

        public Link withColor(@NotNull String color) {
            this.color = color;
            return this;
        }
    }
}

