/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.listener;

import net.william278.huskhomes.event.HomeListEvent;
import net.william278.huskhomes.event.WarpListEvent;
import net.william278.huskhomes.gui.HuskHomesGui;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.menu.ListMenu;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.user.CommandUser;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.User;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ListListener
implements Listener {
    private final HuskHomesGui plugin;

    public ListListener(@NotNull HuskHomesGui plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onHomeListView(@NotNull HomeListEvent event) {
        CommandUser commandUser = event.getListViewer();
        if (!(commandUser instanceof OnlineUser)) {
            return;
        }
        OnlineUser onlineUser = (OnlineUser)commandUser;
        event.setCancelled(true);
        ListMenu<Home> menu = event.getIsPublicHomeList() ? ListMenu.publicHomes(this.plugin, event.getHomes()) : ListMenu.homes(this.plugin, event.getHomes(), event.getHomes().stream().findFirst().map(Home::getOwner).orElse((User)onlineUser));
        menu.show(onlineUser);
    }

    @EventHandler
    public void onWarpListView(@NotNull WarpListEvent event) {
        CommandUser commandUser = event.getListViewer();
        if (!(commandUser instanceof OnlineUser)) {
            return;
        }
        OnlineUser onlineUser = (OnlineUser)commandUser;
        event.setCancelled(true);
        ListMenu.warps(this.plugin, event.getWarps()).show(onlineUser);
    }
}

