/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.config;

import java.util.Optional;
import net.william278.huskhomes.gui.libraries.annotaml.YamlComment;
import net.william278.huskhomes.gui.libraries.annotaml.YamlFile;
import net.william278.huskhomes.gui.libraries.annotaml.YamlKey;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import org.bukkit.Material;

@YamlFile(header="\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503     HuskHomesGUI Config      \u2503\n\u2503    Developed by William278   \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2517\u2578 Information: https://william278.net/project/huskhomesgui")
public class Settings {
    @YamlKey(value="language")
    private String language = "en-gb";
    @YamlComment(value="Options for the home/warp list menu GUI")
    @YamlKey(value="menu.rows")
    private int menuSize = 4;
    @YamlKey(value="menu.show_controls")
    private boolean showMenuControls = true;
    @YamlKey(value="menu.display_controls_help_in_lore")
    private boolean displayControlsHelpInCore = false;
    @YamlKey(value="menu.text_wrap_length")
    private int textWrapLength = 25;
    @YamlKey(value="menu.items.homes_filler")
    private String homesFillerItem = "minecraft:orange_stained_glass_pane";
    @YamlKey(value="menu.items.public_homes_filler")
    private String publicHomesFillerItem = "minecraft:lime_stained_glass_pane";
    @YamlKey(value="menu.items.warps_filler")
    private String warpsFillerItem = "minecraft:cyan_stained_glass_pane";
    @YamlKey(value="menu.items.default_icon")
    private String defaultIcon = "minecraft:stone";
    @YamlKey(value="menu.icons.paginate_first_page")
    private String paginateFirstPage = "minecraft:spectral_arrow";
    @YamlKey(value="menu.icons.paginate_previous_page")
    private String paginatePreviousPage = "minecraft:arrow";
    @YamlKey(value="menu.icons.paginate_next_page")
    private String paginateNextPage = "minecraft:arrow";
    @YamlKey(value="menu.icons.paginate_last_page")
    private String paginateLastPage = "minecraft:spectral_arrow";
    @YamlKey(value="menu.icons.controls_icon")
    private String controlsIcon = "minecraft:oak_sign";
    @YamlComment(value="Options for the home/warp editor GUI")
    @YamlKey(value="editor.icons.home_editor_filler")
    private String homeEditorFillerIcon = "minecraft:lime_stained_glass_pane";
    @YamlKey(value="editor.icons.warp_editor_filler")
    private String warpEditorFillerIcon = "minecraft:lime_stained_glass_pane";
    @YamlKey(value="editor.icons.back_button")
    private String editorBackButtonIcon = "minecraft:orange_stained_glass_pane";
    @YamlKey(value="editor.icons.edit_location_button")
    private String editorEditLocationButtonIcon = "minecraft:oak_boat";
    @YamlKey(value="editor.icons.edit_name_button")
    private String editorEditNameButtonIcon = "minecraft:name_tag";
    @YamlKey(value="editor.icons.edit_description_button")
    private String editorEditDescriptionButtonIcon = "minecraft:writable_book";
    @YamlKey(value="editor.icons.edit_privacy_button")
    private String editorEditPrivacyButtonIcon = "minecraft:nether_star";
    @YamlKey(value="editor.icons.delete_button")
    private String editorDeleteButtonIcon = "minecraft:barrier";

    private Settings() {
    }

    @NotNull
    public String getLanguage() {
        return this.language;
    }

    public int getMenuSize() {
        return Math.max(2, Math.min(this.menuSize, 6));
    }

    public boolean doShowMenuControls() {
        return this.showMenuControls;
    }

    public boolean camelCase() {
        return this.displayControlsHelpInCore;
    }

    public int getTextWrapLength() {
        return this.textWrapLength;
    }

    @NotNull
    public Material getHomesFillerItem() {
        return this.getMaterial(this.homesFillerItem);
    }

    @NotNull
    public Material getPublicHomesFillerItem() {
        return this.getMaterial(this.publicHomesFillerItem);
    }

    @NotNull
    public Material getWarpsFillerItem() {
        return this.getMaterial(this.warpsFillerItem);
    }

    @NotNull
    public Material getDefaultIcon() {
        return this.getMaterial(this.defaultIcon);
    }

    @NotNull
    public Material getPaginateFirstPage() {
        return this.getMaterial(this.paginateFirstPage);
    }

    @NotNull
    public Material getPaginatePreviousPage() {
        return this.getMaterial(this.paginatePreviousPage);
    }

    @NotNull
    public Material getPaginateNextPage() {
        return this.getMaterial(this.paginateNextPage);
    }

    @NotNull
    public Material getPaginateLastPage() {
        return this.getMaterial(this.paginateLastPage);
    }

    @NotNull
    public Material getControlsIcon() {
        return this.getMaterial(this.controlsIcon);
    }

    @NotNull
    public Material getHomeEditorFillerIcon() {
        return this.getMaterial(this.homeEditorFillerIcon);
    }

    @NotNull
    public Material getWarpEditorFillerIcon() {
        return this.getMaterial(this.warpEditorFillerIcon);
    }

    @NotNull
    public Material getEditorBackButtonIcon() {
        return this.getMaterial(this.editorBackButtonIcon);
    }

    @NotNull
    public Material getEditorEditLocationButtonIcon() {
        return this.getMaterial(this.editorEditLocationButtonIcon);
    }

    @NotNull
    public Material getEditorEditNameButtonIcon() {
        return this.getMaterial(this.editorEditNameButtonIcon);
    }

    @NotNull
    public Material getEditorEditDescriptionButtonIcon() {
        return this.getMaterial(this.editorEditDescriptionButtonIcon);
    }

    @NotNull
    public Material getEditorEditPrivacyButtonIcon() {
        return this.getMaterial(this.editorEditPrivacyButtonIcon);
    }

    @NotNull
    public Material getEditorDeleteButtonIcon() {
        return this.getMaterial(this.editorDeleteButtonIcon);
    }

    @NotNull
    private Material getMaterial(@NotNull String id) {
        id = id.replace("minecraft:", "");
        return Optional.ofNullable(Material.matchMaterial((String)id)).orElse(Material.STONE);
    }
}

