/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.menu;

import java.util.List;
import java.util.function.Consumer;
import net.william278.huskhomes.gui.HuskHomesGui;
import net.william278.huskhomes.gui.config.Locales;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.anvilgui.AnvilGUI;
import net.william278.huskhomes.gui.libraries.inventorygui.InventoryGui;
import net.william278.huskhomes.gui.libraries.inventorygui.StaticGuiElement;
import net.william278.huskhomes.gui.menu.ListMenu;
import net.william278.huskhomes.gui.menu.Menu;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.util.ValidationException;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EditMenu<T extends SavedPosition>
extends Menu {
    private final T position;
    private final Menu.Type type;
    private final ListMenu<T> parentMenu;
    private final int pageNumber;

    @NotNull
    private static String[] getEditMenuLayout() {
        return new String[]{"aa     ab", "aundip ra", "aa     aa"};
    }

    private EditMenu(@NotNull HuskHomesGui plugin, @NotNull T position, @NotNull ListMenu<T> parentMenu, int pageNumber) {
        super(plugin, plugin.getLocales().getLocale(position instanceof Home ? "home_editor_title" : "warp_editor_title", position.getName()), EditMenu.getEditMenuLayout());
        this.type = position instanceof Home ? Menu.Type.HOME : Menu.Type.WARP;
        this.position = position;
        this.parentMenu = parentMenu;
        this.pageNumber = pageNumber;
    }

    public static EditMenu<Home> home(@NotNull HuskHomesGui plugin, @NotNull Home home, @NotNull ListMenu<Home> parentMenu, int pageNumber) {
        return new EditMenu<Home>(plugin, home, parentMenu, pageNumber);
    }

    public static EditMenu<Warp> warp(@NotNull HuskHomesGui plugin, @NotNull Warp warp, @NotNull ListMenu<Warp> parentMenu, int pageNumber) {
        return new EditMenu<Warp>(plugin, warp, parentMenu, pageNumber);
    }

    @Override
    protected Consumer<InventoryGui> buildMenu() {
        return menu -> {
            String string;
            Home home;
            ItemStack positionIcon = new ItemStack(this.getPositionMaterial((SavedPosition)this.position).orElse(this.plugin.getSettings().getDefaultIcon()));
            menu.setCloseAction(i -> false);
            menu.addElement(new StaticGuiElement('a', new ItemStack(switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case Menu.Type.HOME, Menu.Type.PUBLIC_HOME -> this.plugin.getSettings().getHomeEditorFillerIcon();
                case Menu.Type.WARP -> this.plugin.getSettings().getWarpEditorFillerIcon();
            }), " "));
            menu.addElement(new StaticGuiElement('b', new ItemStack(this.plugin.getSettings().getEditorBackButtonIcon()), click -> {
                HumanEntity patt4087$temp = click.getWhoClicked();
                if (patt4087$temp instanceof Player) {
                    Player player = (Player)patt4087$temp;
                    OnlineUser user = this.api.adaptUser(player);
                    this.close(user);
                    this.parentMenu.show(user);
                    this.parentMenu.setPageNumber(user, this.pageNumber);
                    this.destroy();
                }
                return true;
            }, this.plugin.getLocales().getLocale("back_button")));
            menu.addElement(new StaticGuiElement('u', new ItemStack(this.plugin.getSettings().getEditorEditLocationButtonIcon()), click -> {
                HumanEntity patt4827$temp = click.getWhoClicked();
                if (patt4827$temp instanceof Player) {
                    Player player = (Player)patt4827$temp;
                    try {
                        T patt4936$temp = this.position;
                        if (patt4936$temp instanceof Home) {
                            Home home = (Home)patt4936$temp;
                            this.api.relocateHome(home, this.api.adaptUser(player).getPosition());
                        } else {
                            T patt5111$temp = this.position;
                            if (patt5111$temp instanceof Warp) {
                                Warp warp = (Warp)patt5111$temp;
                                this.api.relocateWarp(warp, this.api.adaptUser(player).getPosition());
                            }
                        }
                    }
                    catch (ValidationException e) {
                        return true;
                    }
                }
                return true;
            }, this.plugin.getLocales().getLocale("edit_location_button"), this.plugin.getLocales().getLocale("edit_location_default_message", Integer.toString((int)Math.floor(this.position.getX())), Integer.toString((int)Math.floor(this.position.getY())), Integer.toString((int)Math.floor(this.position.getZ())))));
            menu.addElement(new StaticGuiElement('n', new ItemStack(this.plugin.getSettings().getEditorEditNameButtonIcon()), click -> {
                HumanEntity patt6177$temp = click.getWhoClicked();
                if (patt6177$temp instanceof Player) {
                    Player player = (Player)patt6177$temp;
                    this.close(this.api.adaptUser(player));
                    new AnvilGUI.Builder().title(this.plugin.getLocales().getLocale("edit_name_title", this.position.getName())).itemLeft(new ItemStack(positionIcon)).text(this.position.getName()).onClose(playerInAnvil -> this.show(this.api.adaptUser(player))).onClick((slot, stateSnapshot) -> {
                        if (slot == 2) {
                            if (stateSnapshot.getText() != null) {
                                try {
                                    T patt7026$temp = this.position;
                                    if (patt7026$temp instanceof Home) {
                                        Home home = (Home)patt7026$temp;
                                        this.api.renameHome(home, stateSnapshot.getText());
                                    } else {
                                        T patt7227$temp = this.position;
                                        if (patt7227$temp instanceof Warp) {
                                            Warp warp = (Warp)patt7227$temp;
                                            this.api.renameWarp(warp, stateSnapshot.getText());
                                        }
                                    }
                                }
                                catch (ValidationException e) {
                                    return List.of();
                                }
                            }
                            this.position.getMeta().setName(stateSnapshot.getText());
                            this.close(this.api.adaptUser(player));
                            this.destroy();
                            new EditMenu<T>(this.plugin, this.position, this.parentMenu, this.pageNumber).show(this.api.adaptUser(player));
                            return List.of();
                        }
                        return List.of();
                    }).plugin((Plugin)this.plugin).open(player);
                }
                return true;
            }, this.plugin.getLocales().getLocale("edit_name_button")));
            menu.addElement(new StaticGuiElement('d', new ItemStack(this.plugin.getSettings().getEditorEditDescriptionButtonIcon()), click -> {
                HumanEntity patt8859$temp = click.getWhoClicked();
                if (patt8859$temp instanceof Player) {
                    Player player = (Player)patt8859$temp;
                    this.close(this.api.adaptUser(player));
                    new AnvilGUI.Builder().title(this.plugin.getLocales().getLocale("edit_description_title", this.position.getName())).itemLeft(new ItemStack(positionIcon)).text(!this.position.getMeta().getDescription().isBlank() ? this.position.getMeta().getDescription() : this.plugin.getLocales().getLocale("edit_description_default_input")).onClose(playerInAnvil -> this.show(this.api.adaptUser(player))).onClick((slot, stateSnapshot) -> {
                        if (slot == 2) {
                            if (stateSnapshot.getText() != null) {
                                try {
                                    T patt10012$temp = this.position;
                                    if (patt10012$temp instanceof Home) {
                                        Home home = (Home)patt10012$temp;
                                        this.api.setHomeDescription(home, stateSnapshot.getText());
                                    } else {
                                        T patt10221$temp = this.position;
                                        if (patt10221$temp instanceof Warp) {
                                            Warp warp = (Warp)patt10221$temp;
                                            this.api.setWarpDescription(warp, stateSnapshot.getText());
                                        }
                                    }
                                }
                                catch (ValidationException e) {
                                    return List.of();
                                }
                            }
                            this.position.getMeta().setDescription(stateSnapshot.getText());
                            this.show(this.api.adaptUser(player));
                        }
                        return List.of();
                    }).plugin((Plugin)this.plugin).open(player);
                }
                return true;
            }, this.plugin.getLocales().getLocale("edit_description_button"), !this.position.getMeta().getDescription().isBlank() ? this.plugin.getLocales().getLocale("edit_description_default_message", Locales.textWrap(this.plugin, this.position.getMeta().getDescription())) : this.plugin.getLocales().getLocale("edit_description_default_message_blank")));
            T patt11694$temp = this.position;
            if (patt11694$temp instanceof Home) {
                home = (Home)patt11694$temp;
                menu.addElement(new StaticGuiElement('p', new ItemStack(this.plugin.getSettings().getEditorEditPrivacyButtonIcon()), click -> {
                    HumanEntity patt11965$temp = click.getWhoClicked();
                    if (patt11965$temp instanceof Player) {
                        Player player = (Player)patt11965$temp;
                        try {
                            this.api.setHomePrivacy(home, !home.isPublic());
                            home.setPublic(!home.isPublic());
                            this.show(this.api.adaptUser(player));
                        }
                        catch (ValidationException e) {
                            return true;
                        }
                    }
                    return true;
                }, this.plugin.getLocales().getLocale("edit_privacy_button"), this.plugin.getLocales().getLocale("edit_privacy_message", home.isPublic() ? this.plugin.getLocales().getLocale("edit_privacy_message_public") : this.plugin.getLocales().getLocale("edit_privacy_message_private"))));
            }
            menu.addElement(new StaticGuiElement('r', new ItemStack(this.plugin.getSettings().getEditorDeleteButtonIcon()), click -> {
                switch (click.getType()) {
                    case RIGHT: 
                    case DROP: {
                        HumanEntity patt13372$temp = click.getWhoClicked();
                        if (!(patt13372$temp instanceof Player)) break;
                        Player player = (Player)patt13372$temp;
                        this.close(this.api.adaptUser(player));
                        try {
                            T patt13569$temp = this.position;
                            if (patt13569$temp instanceof Home) {
                                Home home = (Home)patt13569$temp;
                                this.api.deleteHome(home);
                                home.getMeta().setName(this.plugin.getLocales().getLocale("item_deleted_name", home.getName()));
                            } else {
                                T patt13877$temp = this.position;
                                if (patt13877$temp instanceof Warp) {
                                    Warp warp = (Warp)patt13877$temp;
                                    this.api.deleteWarp(warp);
                                    warp.getMeta().setName(this.plugin.getLocales().getLocale("item_deleted_name", warp.getName()));
                                }
                            }
                        }
                        catch (ValidationException e) {
                            return true;
                        }
                        OnlineUser user = this.api.adaptUser(player);
                        this.close(user);
                        this.parentMenu.show(user);
                        this.parentMenu.setPageNumber(user, this.pageNumber);
                        this.destroy();
                    }
                }
                return true;
            }, this.plugin.getLocales().getLocale("delete_button"), this.plugin.getLocales().getLocale("delete_button_describe")));
            ItemStack itemStack = new ItemStack(Material.OAK_SIGN);
            String[] stringArray = new String[5];
            stringArray[0] = this.plugin.getLocales().getLocale("item_info_name", this.position.getName());
            stringArray[1] = this.plugin.getLocales().getLocale("item_info_world", this.position.getWorld().getName());
            stringArray[2] = this.plugin.getLocales().getLocale("item_info_server", this.position.getServer());
            stringArray[3] = this.plugin.getLocales().getLocale("item_info_coordinates", Integer.toString((int)Math.floor(this.position.getX())), Integer.toString((int)Math.floor(this.position.getY())), Integer.toString((int)Math.floor(this.position.getZ())));
            T patt16027$temp = this.position;
            if (patt16027$temp instanceof Home) {
                home = (Home)patt16027$temp;
                string = this.plugin.getLocales().getLocale("home_owner_name", home.getOwner().getUsername());
            } else {
                string = "";
            }
            stringArray[4] = string;
            menu.addElement(new StaticGuiElement('i', itemStack, stringArray));
        };
    }
}

