/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.command;

import java.util.ArrayList;
import java.util.List;
import net.william278.huskhomes.gui.HuskHomesGui;
import net.william278.huskhomes.gui.libraries.adventure.audience.Audience;
import net.william278.huskhomes.gui.libraries.adventure.text.Component;
import net.william278.huskhomes.gui.libraries.adventure.text.format.TextColor;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.desertwell.about.AboutMenu;
import net.william278.huskhomes.gui.libraries.minedown.adventure.MineDown;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class HuskHomesGuiCommand
implements CommandExecutor,
TabExecutor {
    private final HuskHomesGui plugin;
    private final AboutMenu aboutMenu;

    public HuskHomesGuiCommand(@NotNull HuskHomesGui plugin) {
        this.plugin = plugin;
        this.aboutMenu = AboutMenu.builder().title(Component.text("HuskHomesGUI")).description(Component.text("Show HuskHomes homes and warps in a simple to use menu")).version(plugin.getPluginVersion()).credits("Author", AboutMenu.Credit.of("William278").description("Click to visit website").url("https://william278.net")).credits("Contributors", AboutMenu.Credit.of("ApliNi").description("Code")).credits("Translators", AboutMenu.Credit.of("ApliNi").description("Simplified Chinese (zh-cn)"), AboutMenu.Credit.of("Revoolt").description("Spanish (es-es)")).buttons(AboutMenu.Link.of("https://william278.net/docs/gui-add-on").text("About").icon("\u26cf"), AboutMenu.Link.of("https://github.com/WiIIiam278/HuskHomesGUI/issues").text("Issues").icon("\u274c").color(TextColor.color(0xFF0000)), AboutMenu.Link.of("https://discord.gg/tVYhJfyDWG").text("Discord").icon("\u2b50").color(TextColor.color(6779893))).build();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        Audience audience;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            audience = this.plugin.getAudiences().player(player.getUniqueId());
        } else {
            audience = this.plugin.getAudiences().console();
        }
        String string = subCommand = args.length >= 1 ? args[0] : "";
        if (subCommand.equals("reload")) {
            this.plugin.reloadConfigFiles();
            audience.sendMessage(new MineDown("[[HuskHomesGUI]](#00fb9a bold) [Reloaded config files!](#00fb9a)").toComponent());
        } else {
            audience.sendMessage(this.aboutMenu.toComponent());
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.filter(List.of("reload", "about"), args);
    }

    @NotNull
    private List<String> filter(@NotNull List<String> list, @NotNull String[] args) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String s : list) {
            if (!s.startsWith(args[args.length - 1])) continue;
            filtered.add(s);
        }
        return filtered;
    }
}

