/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.gui.menu;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.william278.huskhomes.gui.HuskHomesGui;
import net.william278.huskhomes.gui.config.Locales;
import net.william278.huskhomes.gui.libraries.annotations.NotNull;
import net.william278.huskhomes.gui.libraries.inventorygui.DynamicGuiElement;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiElement;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiElementGroup;
import net.william278.huskhomes.gui.libraries.inventorygui.GuiPageElement;
import net.william278.huskhomes.gui.libraries.inventorygui.InventoryGui;
import net.william278.huskhomes.gui.libraries.inventorygui.StaticGuiElement;
import net.william278.huskhomes.gui.menu.EditMenu;
import net.william278.huskhomes.gui.menu.Menu;
import net.william278.huskhomes.position.Home;
import net.william278.huskhomes.position.SavedPosition;
import net.william278.huskhomes.position.Warp;
import net.william278.huskhomes.teleport.Target;
import net.william278.huskhomes.teleport.TeleportationException;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.User;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ListMenu<T extends SavedPosition>
extends Menu {
    private static final String EDIT_HOME_PERMISSION = "huskhomes.command.edithome";
    private static final String EDIT_HOME_OTHER_PERMISSION = "huskhomes.command.edithome.other";
    private static final String EDIT_WARP_PERMISSION = "huskhomes.command.editwarp";
    private final List<T> positions;
    private final Menu.Type type;
    private final int pageNumber = 1;

    @NotNull
    public static ListMenu<Home> homes(@NotNull HuskHomesGui plugin, @NotNull List<Home> homes, @NotNull User owner) {
        return new ListMenu<Home>(plugin, homes, Menu.Type.HOME, plugin.getLocales().getLocale("homes_menu_title", owner.getUsername()));
    }

    @NotNull
    public static ListMenu<Home> publicHomes(@NotNull HuskHomesGui plugin, @NotNull List<Home> homes) {
        return new ListMenu<Home>(plugin, homes, Menu.Type.PUBLIC_HOME, plugin.getLocales().getLocale("public_homes_menu_title"));
    }

    @NotNull
    public static ListMenu<Warp> warps(@NotNull HuskHomesGui plugin, @NotNull List<Warp> warps) {
        return new ListMenu<Warp>(plugin, warps, Menu.Type.WARP, plugin.getLocales().getLocale("warps_menu_title"));
    }

    private ListMenu(@NotNull HuskHomesGui plugin, @NotNull List<T> positions, @NotNull Menu.Type type, @NotNull String title) {
        super(plugin, title, ListMenu.getMenuLayout(plugin));
        this.positions = positions;
        this.type = type;
    }

    @NotNull
    private static String[] getMenuLayout(@NotNull HuskHomesGui plugin) {
        return Arrays.copyOfRange(new String[]{"ppppppppp", "ppppppppp", "ppppppppp", "ppppppppp", "ppppppppp", "bl  i  ne"}, 6 - plugin.getSettings().getMenuSize(), 6);
    }

    @Override
    protected Consumer<InventoryGui> buildMenu() {
        return menu -> {
            menu.setFiller(new ItemStack(this.type.getFillerMaterial(this.plugin.getSettings()), 1));
            menu.addElement(this.getPositionGroup(this.plugin, this.positions));
            menu.addElement(new GuiPageElement('b', new ItemStack(this.plugin.getSettings().getPaginateFirstPage()), GuiPageElement.PageAction.FIRST, this.plugin.getLocales().getLocale("pagination_first_page")));
            menu.addElement(new GuiPageElement('l', new ItemStack(this.plugin.getSettings().getPaginatePreviousPage()), GuiPageElement.PageAction.PREVIOUS, this.plugin.getLocales().getLocale("pagination_previous_page")));
            menu.addElement(new GuiPageElement('n', new ItemStack(this.plugin.getSettings().getPaginateNextPage()), GuiPageElement.PageAction.NEXT, this.plugin.getLocales().getLocale("pagination_next_page")));
            menu.addElement(new GuiPageElement('e', new ItemStack(this.plugin.getSettings().getPaginateLastPage()), GuiPageElement.PageAction.LAST, this.plugin.getLocales().getLocale("pagination_last_page")));
            menu.setPageNumber(1);
            if (this.plugin.getSettings().doShowMenuControls()) {
                menu.addElement(new StaticGuiElement('i', new ItemStack(this.plugin.getSettings().getControlsIcon()), this.plugin.getLocales().getLocale("menu_controls_title"), this.plugin.getLocales().getLocale("menu_controls_details")));
            }
        };
    }

    @NotNull
    private GuiElementGroup getPositionGroup(@NotNull HuskHomesGui plugin, @NotNull List<T> positions) {
        GuiElementGroup group = new GuiElementGroup('p', new GuiElement[0]);
        positions.forEach(position -> group.addElement(this.getPositionButton(plugin, (SavedPosition)position)));
        return group;
    }

    @NotNull
    private DynamicGuiElement getPositionButton(@NotNull HuskHomesGui plugin, @NotNull SavedPosition position) {
        return new DynamicGuiElement('e', viewer -> {
            String string;
            ItemStack itemStack = new ItemStack(this.getPositionMaterial(position).orElse(plugin.getSettings().getDefaultIcon()));
            GuiElement.Action action = click -> {
                HumanEntity patt6258$temp = click.getWhoClicked();
                if (patt6258$temp instanceof Player) {
                    Player player = (Player)patt6258$temp;
                    OnlineUser user = this.api.adaptUser(player);
                    switch (click.getType()) {
                        case LEFT: {
                            ItemStack newItem = player.getItemOnCursor();
                            if (newItem.getType() == Material.AIR) {
                                this.close(user);
                                this.destroy();
                                try {
                                    this.api.teleportBuilder(user).target((Target)position).toTimedTeleport().execute();
                                }
                                catch (TeleportationException teleportationException) {
                                    // empty catch block
                                }
                                return true;
                            }
                            switch (this.type) {
                                case HOME: 
                                case PUBLIC_HOME: {
                                    if (!(player.getUniqueId().equals(((Home)position).getOwner().getUuid()) ? !player.hasPermission(EDIT_HOME_PERMISSION) : !player.hasPermission(EDIT_HOME_OTHER_PERMISSION))) break;
                                    return true;
                                }
                                case WARP: {
                                    if (player.hasPermission(EDIT_WARP_PERMISSION)) break;
                                    return true;
                                }
                            }
                            this.setPositionMaterial(position, newItem.getType());
                            click.getGui().draw();
                            break;
                        }
                        case RIGHT: 
                        case DROP: {
                            Home home;
                            switch (this.type) {
                                case WARP: {
                                    if (player.hasPermission(EDIT_WARP_PERMISSION)) break;
                                    return true;
                                }
                                case HOME: 
                                case PUBLIC_HOME: {
                                    if (!(position instanceof Home)) break;
                                    home = (Home)position;
                                    if (!player.hasPermission(EDIT_HOME_PERMISSION)) {
                                        return true;
                                    }
                                    if (player.getUniqueId().equals(home.getOwner().getUuid()) || player.hasPermission(EDIT_HOME_OTHER_PERMISSION)) break;
                                    return true;
                                }
                            }
                            if (position instanceof Home) {
                                home = (Home)position;
                                EditMenu.home(plugin, home, this, this.getPageNumber(user)).show(user);
                                break;
                            }
                            if (!(position instanceof Warp)) break;
                            Warp warp = (Warp)position;
                            EditMenu.warp(plugin, warp, this, this.getPageNumber(user)).show(user);
                        }
                    }
                }
                return true;
            };
            String[] stringArray = new String[4];
            stringArray[0] = this.type == Menu.Type.HOME && ((Home)position).isPublic() ? plugin.getLocales().getLocale("item_name_public", position.getName()) : plugin.getLocales().getLocale("item_name", position.getName());
            String string2 = stringArray[1] = !position.getMeta().getDescription().isBlank() ? plugin.getLocales().getLocale("item_description", Locales.textWrap(plugin, position.getMeta().getDescription())) : plugin.getLocales().getLocale("item_description_blank");
            if (position instanceof Home) {
                Home home = (Home)position;
                string = this.type == Menu.Type.PUBLIC_HOME ? plugin.getLocales().getLocale("home_owner_name", home.getOwner().getUsername()) : "";
            } else {
                string = "";
            }
            stringArray[2] = string;
            stringArray[3] = plugin.getSettings().camelCase() ? plugin.getLocales().getLocale("item_controls") : "";
            return new StaticGuiElement('e', itemStack, action, stringArray);
        });
    }
}

