/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import lombok.Generated;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import net.william278.papiproxybridge.ProxyPAPIProxyBridge;
import net.william278.papiproxybridge.api.PlaceholderAPI;
import net.william278.papiproxybridge.config.Settings;
import net.william278.papiproxybridge.libraries.bstats.bungeecord.Metrics;
import net.william278.papiproxybridge.libraries.bstats.charts.SimplePie;
import net.william278.papiproxybridge.messenger.Messenger;
import net.william278.papiproxybridge.messenger.PluginMessageMessenger;
import net.william278.papiproxybridge.messenger.redis.RedisMessenger;
import net.william278.papiproxybridge.user.BungeeUser;
import org.jetbrains.annotations.NotNull;

public class BungeePAPIProxyBridge
extends Plugin
implements ProxyPAPIProxyBridge,
Listener {
    private ConcurrentMap<UUID, CompletableFuture<String>> requests;
    private Map<UUID, BungeeUser> users;
    private Settings settings;
    private Messenger messenger;

    public void onEnable() {
        this.requests = Maps.newConcurrentMap();
        this.users = Maps.newConcurrentMap();
        this.loadConfig();
        this.loadMessenger();
        this.messenger.onEnable();
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        PlaceholderAPI.register(this);
        this.setupMetrics();
        this.getLogger().info(this.getLoadMessage());
    }

    public void onDisable() {
        this.messenger.onDisable();
        this.getProxy().getPluginManager().unregisterListener((Listener)this);
    }

    @EventHandler
    public void onPluginMessageReceived(PluginMessageEvent event) {
        this.handleMessage(this, event.getTag(), event.getData(), false);
    }

    @EventHandler
    public void onJoin(PostLoginEvent event) {
        BungeeUser user = BungeeUser.adapt(event.getPlayer());
        this.users.put(user.getUniqueId(), user);
    }

    @EventHandler
    public void onQuit(PostLoginEvent event) {
        BungeeUser user = BungeeUser.adapt(event.getPlayer());
        this.users.remove(user.getUniqueId());
        PlaceholderAPI.clearCache(event.getPlayer().getUniqueId());
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics(this, 17879);
        metrics.addCustomChart(new SimplePie("messengerType", () -> this.getSettings().getMessenger().name()));
    }

    @Override
    public String getServerType() {
        return "BungeeCord";
    }

    @NotNull
    public Collection<BungeeUser> getOnlineUsers() {
        return this.users.values();
    }

    public Optional<BungeeUser> findPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(this.users.get(uuid));
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        if (exceptions.length > 0) {
            this.getLogger().log(level, message, exceptions[0]);
        } else {
            this.getLogger().log(level, message);
        }
    }

    @Override
    public void loadMessenger() {
        switch (this.settings.getMessenger()) {
            case REDIS: {
                this.messenger = new RedisMessenger(this, this.settings.getRedis(), false);
                break;
            }
            case PLUGIN_MESSAGE: {
                this.messenger = new PluginMessageMessenger(this);
            }
        }
        this.log(Level.INFO, "Loaded messenger " + this.settings.getMessenger().name(), new Throwable[0]);
    }

    @Override
    @Generated
    public ConcurrentMap<UUID, CompletableFuture<String>> getRequests() {
        return this.requests;
    }

    @Generated
    public Map<UUID, BungeeUser> getUsers() {
        return this.users;
    }

    @Override
    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    @Generated
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Override
    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

