/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import net.william278.papiproxybridge.libraries.lettuce.core.ScoredValue;
import net.william278.papiproxybridge.libraries.lettuce.core.StreamScanCursor;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceStrings;
import net.william278.papiproxybridge.libraries.lettuce.core.output.ScanOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.ScoredValueStreamingChannel;

public class ScoredValueScanStreamingOutput<K, V>
extends ScanOutput<K, V, StreamScanCursor> {
    private final ScoredValueStreamingChannel<V> channel;
    private V value;
    private boolean hasValue;

    public ScoredValueScanStreamingOutput(RedisCodec<K, V> codec, ScoredValueStreamingChannel<V> channel) {
        super(codec, new StreamScanCursor());
        this.channel = channel;
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (!this.hasValue) {
            this.value = this.codec.decodeValue(bytes);
            this.hasValue = true;
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeString(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        if (this.hasValue) {
            this.channel.onValue(ScoredValue.just(number, this.value));
        }
        ((StreamScanCursor)this.output).setCount(((StreamScanCursor)this.output).getCount() + 1L);
        this.value = null;
        this.hasValue = false;
    }
}

