/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiConsumer;
import net.william278.papiproxybridge.libraries.reactor.core.CoreSubscriber;
import net.william278.papiproxybridge.libraries.reactor.core.Fuseable;
import net.william278.papiproxybridge.libraries.reactor.core.Scannable;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.ContextPropagation;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.ContextPropagationSupport;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.FluxHandleFuseable;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.InternalMonoOperator;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.Mono;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.SynchronousSink;

final class MonoHandleFuseable<T, R>
extends InternalMonoOperator<T, R>
implements Fuseable {
    final BiConsumer<? super T, SynchronousSink<R>> handler;

    MonoHandleFuseable(Mono<? extends T> source, BiConsumer<? super T, SynchronousSink<R>> handler) {
        super(source);
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super R> actual) {
        BiConsumer<? super T, SynchronousSink<R>> handler2 = ContextPropagationSupport.shouldRestoreThreadLocalsInSomeOperators() ? ContextPropagation.contextRestoreForHandle(this.handler, actual::currentContext) : this.handler;
        return new FluxHandleFuseable.HandleFuseableSubscriber<T, R>(actual, handler2);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

