/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.william278.papiproxybridge.PAPIProxyBridge;
import net.william278.papiproxybridge.user.OnlineUser;
import net.william278.papiproxybridge.user.ProxyUser;
import net.william278.papiproxybridge.user.Request;
import org.jetbrains.annotations.NotNull;

public interface ProxyPAPIProxyBridge
extends PAPIProxyBridge {
    @NotNull
    public ConcurrentMap<UUID, CompletableFuture<String>> getRequests();

    @Override
    default public CompletableFuture<String> createRequest(@NotNull String text, @NotNull OnlineUser requester, @NotNull UUID formatFor, boolean wantsJson, long requestTimeout) {
        Request request = new Request(text, formatFor);
        CompletableFuture<String> future = new CompletableFuture<String>();
        this.getRequests().put(request.getUuid(), future);
        future.exceptionallyAsync(throwable -> {
            this.getRequests().remove(request.getUuid());
            return text;
        });
        requester.sendMessage(this, request, wantsJson, true);
        return future;
    }

    @Override
    default public CompletableFuture<Set<String>> getServers(long requestTimeout) {
        CompletableFuture<Set<String>> future = new CompletableFuture<Set<String>>();
        Multimap serverMap = (Multimap)this.getOnlineUsers().stream().filter(user -> user instanceof ProxyUser).map(user -> (ProxyUser)user).filter(OnlineUser::isConnected).collect(() -> Multimaps.newSetMultimap((Map)Maps.newConcurrentMap(), Sets::newConcurrentHashSet), (map, user) -> map.put((Object)user.getServerName(), (Object)this.createRequest("%papiproxybridge_handshake%", (OnlineUser)user, user.getUniqueId(), false, requestTimeout).thenApply(message -> message.equals("confirmed"))), Multimap::putAll);
        CompletableFuture.allOf(serverMap.values().toArray(new CompletableFuture[0])).thenRun(() -> {
            Set servers = serverMap.asMap().entrySet().stream().filter(entry -> ((Collection)entry.getValue()).stream().anyMatch(CompletableFuture::join)).map(Map.Entry::getKey).collect(Collectors.toSet());
            future.complete(Set.copyOf(servers));
        });
        return future;
    }
}

