/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core;

import java.util.List;
import java.util.function.Supplier;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.json.JsonParser;
import net.william278.papiproxybridge.libraries.lettuce.core.json.JsonPath;
import net.william278.papiproxybridge.libraries.lettuce.core.json.JsonType;
import net.william278.papiproxybridge.libraries.lettuce.core.json.JsonValue;
import net.william278.papiproxybridge.libraries.lettuce.core.json.arguments.JsonGetArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.json.arguments.JsonMsetArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.json.arguments.JsonRangeArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.json.arguments.JsonSetArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.output.ArrayOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.IntegerOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.JsonTypeListOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.JsonValueListOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.NumberListOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.StatusOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.ValueListOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.BaseRedisCommandBuilder;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.Command;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandType;

class RedisJsonCommandBuilder<K, V>
extends BaseRedisCommandBuilder<K, V> {
    private final Supplier<JsonParser> parser;

    RedisJsonCommandBuilder(RedisCodec<K, V> codec, Supplier<JsonParser> theParser) {
        super(codec);
        this.parser = theParser;
    }

    Command<K, V, List<Long>> jsonArrappend(K key, JsonPath jsonPath, JsonValue ... jsonValues) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (jsonPath != null && !jsonPath.isRootPath()) {
            args.add(jsonPath.toString());
        }
        for (JsonValue value : jsonValues) {
            args.add(value.asByteBuffer().array());
        }
        return this.createCommand(CommandType.JSON_ARRAPPEND, new ArrayOutput(this.codec), args);
    }

    Command<K, V, List<Long>> jsonArrindex(K key, JsonPath jsonPath, JsonValue value, JsonRangeArgs range) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        args.add(jsonPath.toString());
        args.add(value.asByteBuffer().array());
        if (range != null) {
            range.build(args);
        }
        return this.createCommand(CommandType.JSON_ARRINDEX, new ArrayOutput(this.codec), args);
    }

    Command<K, V, List<Long>> jsonArrinsert(K key, JsonPath jsonPath, int index, JsonValue ... values) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        args.add(jsonPath.toString());
        args.add(index);
        for (JsonValue value : values) {
            args.add(value.asByteBuffer().array());
        }
        return this.createCommand(CommandType.JSON_ARRINSERT, new ArrayOutput(this.codec), args);
    }

    Command<K, V, List<Long>> jsonArrlen(K key, JsonPath jsonPath) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (jsonPath != null && !jsonPath.isRootPath()) {
            args.add(jsonPath.toString());
        }
        return this.createCommand(CommandType.JSON_ARRLEN, new ArrayOutput(this.codec), args);
    }

    Command<K, V, List<JsonValue>> jsonArrpop(K key, JsonPath jsonPath, int index) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (jsonPath != null && !jsonPath.isRootPath()) {
            args.add(jsonPath.toString());
            if (index != -1) {
                args.add(index);
            }
        }
        return this.createCommand(CommandType.JSON_ARRPOP, new JsonValueListOutput(this.codec, this.parser.get()), args);
    }

    Command<K, V, List<Long>> jsonArrtrim(K key, JsonPath jsonPath, JsonRangeArgs range) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        args.add(jsonPath.toString());
        if (range != null) {
            range.build(args);
        }
        return this.createCommand(CommandType.JSON_ARRTRIM, new ArrayOutput(this.codec), args);
    }

    Command<K, V, Long> jsonClear(K key, JsonPath jsonPath) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (jsonPath != null && !jsonPath.isRootPath()) {
            args.add(jsonPath.toString());
        }
        return this.createCommand(CommandType.JSON_CLEAR, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<JsonValue>> jsonGet(K key, JsonGetArgs options, JsonPath ... jsonPaths) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (options != null) {
            options.build(args);
        }
        if (jsonPaths != null) {
            for (JsonPath jsonPath : jsonPaths) {
                if (jsonPath == null) continue;
                args.add(jsonPath.toString());
            }
        }
        return this.createCommand(CommandType.JSON_GET, new JsonValueListOutput(this.codec, this.parser.get()), args);
    }

    Command<K, V, String> jsonMerge(K key, JsonPath jsonPath, JsonValue value) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        args.add(jsonPath.toString());
        args.add(value.asByteBuffer().array());
        return this.createCommand(CommandType.JSON_MERGE, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<JsonValue>> jsonMGet(JsonPath jsonPath, K ... keys) {
        RedisJsonCommandBuilder.notEmpty(keys);
        CommandArgs args = new CommandArgs(this.codec).addKeys(keys);
        args.add(jsonPath.toString());
        return this.createCommand(CommandType.JSON_MGET, new JsonValueListOutput(this.codec, this.parser.get()), args);
    }

    Command<K, V, String> jsonMSet(List<JsonMsetArgs<K, V>> arguments) {
        RedisJsonCommandBuilder.notEmpty(arguments.toArray());
        CommandArgs args = new CommandArgs(this.codec);
        for (JsonMsetArgs argument : arguments) {
            argument.build(args);
        }
        return this.createCommand(CommandType.JSON_MSET, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<Number>> jsonNumincrby(K key, JsonPath jsonPath, Number number) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        args.add(jsonPath.toString());
        args.add(number.toString());
        return this.createCommand(CommandType.JSON_NUMINCRBY, new NumberListOutput(this.codec), args);
    }

    Command<K, V, List<V>> jsonObjkeys(K key, JsonPath jsonPath) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (jsonPath != null && !jsonPath.isRootPath()) {
            args.add(jsonPath.toString());
        }
        return this.createCommand(CommandType.JSON_OBJKEYS, new ValueListOutput(this.codec), args);
    }

    Command<K, V, List<Long>> jsonObjlen(K key, JsonPath jsonPath) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (jsonPath != null && !jsonPath.isRootPath()) {
            args.add(jsonPath.toString());
        }
        return this.createCommand(CommandType.JSON_OBJLEN, new ArrayOutput(this.codec), args);
    }

    Command<K, V, String> jsonSet(K key, JsonPath jsonPath, JsonValue value, JsonSetArgs options) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        args.add(jsonPath.toString());
        args.add(value.asByteBuffer().array());
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(CommandType.JSON_SET, new StatusOutput(this.codec), args);
    }

    Command<K, V, List<Long>> jsonStrappend(K key, JsonPath jsonPath, JsonValue value) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (jsonPath != null && !jsonPath.isRootPath()) {
            args.add(jsonPath.toString());
        }
        args.add(value.asByteBuffer().array());
        return this.createCommand(CommandType.JSON_STRAPPEND, new ArrayOutput(this.codec), args);
    }

    Command<K, V, List<Long>> jsonStrlen(K key, JsonPath jsonPath) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (jsonPath != null && !jsonPath.isRootPath()) {
            args.add(jsonPath.toString());
        }
        return this.createCommand(CommandType.JSON_STRLEN, new ArrayOutput(this.codec), args);
    }

    Command<K, V, List<Long>> jsonToggle(K key, JsonPath jsonPath) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        args.add(jsonPath.toString());
        return this.createCommand(CommandType.JSON_TOGGLE, new ArrayOutput(this.codec), args);
    }

    Command<K, V, Long> jsonDel(K key, JsonPath jsonPath) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (jsonPath != null && !jsonPath.isRootPath()) {
            args.add(jsonPath.toString());
        }
        return this.createCommand(CommandType.JSON_DEL, new IntegerOutput(this.codec), args);
    }

    Command<K, V, List<JsonType>> jsonType(K key, JsonPath jsonPath) {
        RedisJsonCommandBuilder.notNullKey(key);
        CommandArgs args = new CommandArgs(this.codec).addKey(key);
        if (jsonPath != null && !jsonPath.isRootPath()) {
            args.add(jsonPath.toString());
        }
        return this.createCommand(CommandType.JSON_TYPE, new JsonTypeListOutput(this.codec), args);
    }
}

