/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import net.william278.papiproxybridge.libraries.lettuce.core.CompositeArgument;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceAssert;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandKeyword;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandType;

public class XClaimArgs
implements CompositeArgument {
    long minIdleTime;
    private Long idle;
    private Long time;
    private Long retrycount;
    private boolean force;
    private boolean justid;

    public XClaimArgs justid() {
        this.justid = true;
        return this;
    }

    public XClaimArgs minIdleTime(long milliseconds) {
        this.minIdleTime = milliseconds;
        return this;
    }

    public XClaimArgs minIdleTime(Duration minIdleTime) {
        LettuceAssert.notNull((Object)minIdleTime, "Min idle time must not be null");
        return this.minIdleTime(minIdleTime.toMillis());
    }

    public XClaimArgs idle(long milliseconds) {
        this.idle = milliseconds;
        return this;
    }

    public XClaimArgs idle(Duration idleTime) {
        LettuceAssert.notNull((Object)idleTime, "Idle time must not be null");
        return this.idle(idleTime.toMillis());
    }

    public XClaimArgs time(long millisecondsUnixTime) {
        this.time = millisecondsUnixTime;
        return this;
    }

    public XClaimArgs time(TemporalAccessor timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.time(Instant.from(timestamp).toEpochMilli());
    }

    public XClaimArgs retryCount(long retrycount) {
        this.retrycount = retrycount;
        return this;
    }

    public XClaimArgs force() {
        return this.force(true);
    }

    public XClaimArgs force(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.idle != null) {
            args.add(CommandKeyword.IDLE).add(this.idle);
        }
        if (this.time != null) {
            args.add(CommandType.TIME).add(this.time);
        }
        if (this.retrycount != null) {
            args.add(CommandKeyword.RETRYCOUNT).add(this.retrycount);
        }
        if (this.force) {
            args.add(CommandKeyword.FORCE);
        }
        if (this.justid) {
            args.add(CommandKeyword.JUSTID);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static XClaimArgs justid() {
            return new XClaimArgs().justid();
        }

        public static XClaimArgs minIdleTime(long milliseconds) {
            return new XClaimArgs().minIdleTime(milliseconds);
        }

        public static XClaimArgs minIdleTime(Duration minIdleTime) {
            LettuceAssert.notNull((Object)minIdleTime, "Min idle time must not be null");
            return Builder.minIdleTime(minIdleTime.toMillis());
        }
    }
}

