/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.event;

import net.william278.papiproxybridge.libraries.lettuce.core.event.Event;
import net.william278.papiproxybridge.libraries.lettuce.core.event.EventBus;
import net.william278.papiproxybridge.libraries.lettuce.core.event.jfr.EventRecorder;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.Flux;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.Sinks;
import net.william278.papiproxybridge.libraries.reactor.core.scheduler.Scheduler;

public class DefaultEventBus
implements EventBus {
    private final Sinks.Many<Event> bus;
    private final Scheduler scheduler;
    private final EventRecorder recorder = EventRecorder.getInstance();

    public DefaultEventBus(Scheduler scheduler) {
        this.bus = Sinks.many().multicast().directBestEffort();
        this.scheduler = scheduler;
    }

    @Override
    public Flux<Event> get() {
        return this.bus.asFlux().onBackpressureDrop().publishOn(this.scheduler);
    }

    @Override
    public void publish(Event event) {
        Sinks.EmitResult emitResult;
        this.recorder.record(event);
        while ((emitResult = this.bus.tryEmitNext(event)) == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
        }
        if (emitResult != Sinks.EmitResult.FAIL_ZERO_SUBSCRIBER) {
            emitResult.orThrow();
        }
    }
}

