/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import net.william278.papiproxybridge.libraries.lettuce.core.KeyValue;
import net.william278.papiproxybridge.libraries.lettuce.core.ScoredValue;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceStrings;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;

public class KeyValueScoredValueOutput<K, V>
extends CommandOutput<K, V, KeyValue<K, ScoredValue<V>>> {
    private K key;
    private boolean hasKey;
    private V value;
    private boolean hasValue;

    public KeyValueScoredValueOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null) {
            return;
        }
        if (!this.hasKey) {
            this.key = this.codec.decodeKey(bytes);
            this.hasKey = true;
            return;
        }
        if (!this.hasValue) {
            this.value = this.codec.decodeValue(bytes);
            this.hasValue = true;
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeString(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        this.output = KeyValue.just(this.key, ScoredValue.just(number, this.value));
        this.key = null;
        this.hasKey = false;
        this.value = null;
        this.hasValue = false;
    }
}

