/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.resource;

import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.ThreadFactory;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceAssert;
import net.william278.papiproxybridge.libraries.lettuce.core.resource.EventLoopResources;
import net.william278.papiproxybridge.libraries.lettuce.core.resource.EventLoopResourcesWrapper;
import net.william278.papiproxybridge.libraries.lettuce.core.resource.UnavailableResources;
import net.william278.papiproxybridge.libraries.netty.bootstrap.Bootstrap;
import net.william278.papiproxybridge.libraries.netty.channel.Channel;
import net.william278.papiproxybridge.libraries.netty.channel.EventLoopGroup;
import net.william278.papiproxybridge.libraries.netty.channel.epoll.Epoll;
import net.william278.papiproxybridge.libraries.netty.channel.epoll.EpollChannelOption;
import net.william278.papiproxybridge.libraries.netty.channel.epoll.EpollDatagramChannel;
import net.william278.papiproxybridge.libraries.netty.channel.epoll.EpollDomainSocketChannel;
import net.william278.papiproxybridge.libraries.netty.channel.epoll.EpollEventLoopGroup;
import net.william278.papiproxybridge.libraries.netty.channel.epoll.EpollSocketChannel;
import net.william278.papiproxybridge.libraries.netty.channel.socket.DatagramChannel;
import net.william278.papiproxybridge.libraries.netty.channel.unix.DomainSocketAddress;
import net.william278.papiproxybridge.libraries.netty.util.concurrent.EventExecutorGroup;
import net.william278.papiproxybridge.libraries.netty.util.internal.SystemPropertyUtil;
import net.william278.papiproxybridge.libraries.netty.util.internal.logging.InternalLogger;
import net.william278.papiproxybridge.libraries.netty.util.internal.logging.InternalLoggerFactory;

public class EpollProvider {
    private static final InternalLogger logger;
    private static final String EPOLL_ENABLED_KEY = "net.william278.papiproxybridge.libraries.lettuce.core.epoll";
    private static final boolean EPOLL_ENABLED;
    private static final boolean EPOLL_AVAILABLE;
    private static final EventLoopResources EPOLL_RESOURCES;

    public static boolean isAvailable() {
        return EPOLL_AVAILABLE && EPOLL_ENABLED;
    }

    static void checkForEpollLibrary() {
        LettuceAssert.assertState(EPOLL_ENABLED, String.format("epoll use is disabled via System properties (%s)", EPOLL_ENABLED_KEY));
        LettuceAssert.assertState(EpollProvider.isAvailable(), "netty-transport-native-epoll is not available. Make sure netty-transport-native-epoll library on the class path and supported by your operating system.");
    }

    public static EventLoopResources getResources() {
        return EPOLL_RESOURCES;
    }

    public static void applyKeepAlive(Bootstrap bootstrap, int count, Duration idle, Duration interval) {
        bootstrap.option(EpollChannelOption.TCP_KEEPCNT, count);
        bootstrap.option(EpollChannelOption.TCP_KEEPIDLE, Math.toIntExact(idle.getSeconds()));
        bootstrap.option(EpollChannelOption.TCP_KEEPINTVL, Math.toIntExact(interval.getSeconds()));
    }

    public static void applyTcpUserTimeout(Bootstrap bootstrap, Duration timeout) {
        bootstrap.option(EpollChannelOption.TCP_USER_TIMEOUT, Math.toIntExact(timeout.toMillis()));
    }

    static {
        boolean availability;
        logger = InternalLoggerFactory.getInstance(EpollProvider.class);
        EPOLL_ENABLED = Boolean.parseBoolean(SystemPropertyUtil.get(EPOLL_ENABLED_KEY, "true"));
        try {
            Class.forName("net.william278.papiproxybridge.libraries.netty.channel.epoll.Epoll");
            availability = Epoll.isAvailable();
        }
        catch (ClassNotFoundException e) {
            availability = false;
        }
        EPOLL_AVAILABLE = availability;
        if (EPOLL_AVAILABLE) {
            logger.debug("Starting with epoll library");
            EPOLL_RESOURCES = new EventLoopResourcesWrapper(EpollResources.INSTANCE, EpollProvider::checkForEpollLibrary);
        } else {
            logger.debug("Starting without optional epoll library");
            EPOLL_RESOURCES = new EventLoopResourcesWrapper(UnavailableResources.INSTANCE, EpollProvider::checkForEpollLibrary);
        }
    }

    static enum EpollResources implements EventLoopResources
    {
        INSTANCE;


        @Override
        public boolean matches(Class<? extends EventExecutorGroup> type) {
            LettuceAssert.notNull(type, "EventLoopGroup type must not be null");
            return type.equals(EpollEventLoopGroup.class);
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            return EpollEventLoopGroup.class;
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            return new EpollEventLoopGroup(nThreads, threadFactory);
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            return EpollSocketChannel.class;
        }

        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            return EpollDomainSocketChannel.class;
        }

        @Override
        public Class<? extends DatagramChannel> datagramChannelClass() {
            return EpollDatagramChannel.class;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            return new DomainSocketAddress(socketPath);
        }
    }
}

