/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.resource;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.william278.papiproxybridge.libraries.lettuce.core.resource.Delay;

class ExponentialDelay
extends Delay {
    private final Duration lower;
    private final Duration upper;
    private final int powersOf;
    private final TimeUnit targetTimeUnit;

    ExponentialDelay(Duration lower, Duration upper, int powersOf, TimeUnit targetTimeUnit) {
        this.lower = lower;
        this.upper = upper;
        this.powersOf = powersOf;
        this.targetTimeUnit = targetTimeUnit;
    }

    @Override
    public Duration createDelay(long attempt) {
        long delay = attempt <= 0L ? 0L : (this.powersOf == 2 ? ExponentialDelay.calculatePowerOfTwo(attempt) : this.calculateAlternatePower(attempt));
        return this.applyBounds(Duration.ofNanos(this.targetTimeUnit.toNanos(delay)));
    }

    protected Duration applyBounds(Duration delay) {
        return ExponentialDelay.applyBounds(delay, this.lower, this.upper);
    }

    private long calculateAlternatePower(long attempt) {
        double step = Math.pow(this.powersOf, attempt - 1L);
        return Math.round(step);
    }

    protected static long calculatePowerOfTwo(long attempt) {
        if (attempt <= 0L) {
            return 0L;
        }
        if (attempt >= 63L) {
            return 0x7FFFFFFFFFFFFFFEL;
        }
        return 1L << (int)(attempt - 1L);
    }
}

