/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.netty.resolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import net.william278.papiproxybridge.libraries.netty.resolver.InetNameResolver;
import net.william278.papiproxybridge.libraries.netty.util.concurrent.EventExecutor;
import net.william278.papiproxybridge.libraries.netty.util.concurrent.Promise;
import net.william278.papiproxybridge.libraries.netty.util.internal.SocketUtils;

public class DefaultNameResolver
extends InetNameResolver {
    public DefaultNameResolver(EventExecutor executor) {
        super(executor);
    }

    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise) throws Exception {
        try {
            promise.setSuccess(SocketUtils.addressByName(inetHost));
        }
        catch (UnknownHostException e) {
            promise.setFailure(e);
        }
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) throws Exception {
        try {
            promise.setSuccess(Arrays.asList(SocketUtils.allAddressesByName(inetHost)));
        }
        catch (UnknownHostException e) {
            promise.setFailure(e);
        }
    }
}

