/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.api;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.william278.papiproxybridge.PAPIProxyBridge;
import net.william278.papiproxybridge.config.Settings;
import net.william278.papiproxybridge.libraries.expiringmap.ExpiringMap;
import net.william278.papiproxybridge.user.OnlineUser;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class PlaceholderAPI {
    private static final Set<PlaceholderAPI> instances = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private static PAPIProxyBridge plugin;
    private static final ScheduledExecutorService SCHEDULER;
    private static final String PLACEHOLDER_DELIMITER = "%%%-%%%";
    private final ConcurrentMap<UUID, ExpiringMap<String, String>> cache = Maps.newConcurrentMap();
    private final ConcurrentMap<UUID, ExpiringMap<String, Component>> componentCache = Maps.newConcurrentMap();
    private long requestTimeout = 1000L;
    private long cacheExpiry = 30000L;
    private int retryTimes = 3;
    private long lastError = 0L;

    @ApiStatus.Internal
    private PlaceholderAPI() {
    }

    @Deprecated(since="1.3")
    @NotNull
    public static PlaceholderAPI getInstance() {
        return PlaceholderAPI.createInstance();
    }

    @NotNull
    public static PlaceholderAPI createInstance() {
        PlaceholderAPI instance = new PlaceholderAPI();
        instances.add(instance);
        return instance;
    }

    @ApiStatus.Internal
    public static void register(@NotNull PAPIProxyBridge plugin) {
        PlaceholderAPI.plugin = plugin;
    }

    @ApiStatus.Internal
    public static void clearCache(@NotNull UUID player) {
        instances.forEach(instance -> {
            instance.cache.remove(player);
            instance.componentCache.remove(player);
        });
    }

    private static <T> CompletableFuture<T> orTimeoutAsync(CompletableFuture<T> future, long timeout) {
        CompletableFuture timeoutFuture = new CompletableFuture();
        timeoutFuture.exceptionally(t -> {
            if (t instanceof CancellationException) {
                future.cancel(true);
            }
            return null;
        });
        SCHEDULER.schedule(() -> {
            TimeoutException timeoutException = new TimeoutException("Timeout reached");
            timeoutFuture.completeExceptionally(timeoutException);
            future.completeExceptionally(timeoutException);
        }, timeout, TimeUnit.MILLISECONDS);
        return CompletableFuture.anyOf(future, timeoutFuture).thenApply(o -> o);
    }

    public CompletableFuture<String> formatPlaceholders(@NotNull String text, @NotNull OnlineUser requester, @NotNull UUID formatFor) {
        return this.formatPlaceholders(text, requester, formatFor, this.retryTimes);
    }

    private CompletableFuture<String> formatPlaceholders(@NotNull String text, @NotNull OnlineUser requester, @NotNull UUID formatFor, int times) {
        if (!requester.isConnected()) {
            return CompletableFuture.completedFuture(text);
        }
        if (this.cacheExpiry > 0L && this.cache.containsKey(formatFor) && ((ExpiringMap)this.cache.get(formatFor)).containsKey(text)) {
            return CompletableFuture.completedFuture((String)((ExpiringMap)this.cache.get(formatFor)).get(text));
        }
        CompletableFuture<String> future = plugin.createRequest(text, requester, formatFor, false, this.requestTimeout);
        return ((CompletableFuture)PlaceholderAPI.orTimeoutAsync(future, this.requestTimeout).thenApply(formatted -> {
            this.cache.computeIfAbsent(requester.getUniqueId(), uuid -> ExpiringMap.builder().expiration(this.cacheExpiry, TimeUnit.MILLISECONDS).build()).put(text, formatted);
            return formatted;
        })).exceptionally(e -> {
            if (!requester.isConnected()) {
                return text;
            }
            if (this.checkLastError()) {
                return text;
            }
            if (!(e instanceof CompletionException)) {
                if (!Arrays.stream(e.getSuppressed()).anyMatch(TimeoutException.class::isInstance)) {
                    plugin.log(Level.WARNING, "Failed to format placeholders for %s".formatted(requester.getUsername()), (Throwable)e);
                    return text;
                }
            }
            plugin.log(Level.WARNING, "Timed out formatting placeholders for %s after %sms.Is PAPIProxyBridge up-to-date and installed on all backend servers?".formatted(requester.getUsername(), this.getRequestTimeout()), new Throwable[0]);
            return text;
        });
    }

    public CompletableFuture<String> formatPlaceholders(@NotNull String text, @NotNull OnlineUser player) {
        return this.formatPlaceholders(text, player, player.getUniqueId());
    }

    public CompletableFuture<String> formatPlaceholders(@NotNull String text, @NotNull UUID requester, @NotNull UUID formatFor) {
        return plugin.findPlayer(requester).map(onlineRequester -> this.formatPlaceholders(text, (OnlineUser)onlineRequester, formatFor)).orElse(CompletableFuture.completedFuture(text));
    }

    public CompletableFuture<String> formatPlaceholders(@NotNull String text, @NotNull UUID player) {
        return plugin.findPlayer(player).map(requester -> this.formatPlaceholders(text, (OnlineUser)requester, player)).orElse(CompletableFuture.completedFuture(text));
    }

    public CompletableFuture<Component> formatComponentPlaceholders(@NotNull String text, @NotNull OnlineUser requester, @NotNull UUID formatFor) {
        return this.formatComponentPlaceholders(text, requester, formatFor, this.retryTimes);
    }

    private CompletableFuture<Component> formatComponentPlaceholders(@NotNull String text, @NotNull OnlineUser requester, @NotNull UUID formatFor, int times) {
        if (!requester.isConnected()) {
            return CompletableFuture.completedFuture(Component.text(text));
        }
        if (this.cacheExpiry > 0L && this.componentCache.containsKey(formatFor) && ((ExpiringMap)this.componentCache.get(formatFor)).containsKey(text)) {
            return CompletableFuture.completedFuture((Component)((ExpiringMap)this.componentCache.get(formatFor)).get(text));
        }
        CompletableFuture<String> future = plugin.createRequest(text, requester, formatFor, true, this.requestTimeout);
        return ((CompletableFuture)PlaceholderAPI.orTimeoutAsync(future, this.requestTimeout).thenApply(formatted -> {
            TextComponent deserialized = GsonComponentSerializer.gson().deserializeOr(formatted, Component.text(formatted));
            this.componentCache.computeIfAbsent(requester.getUniqueId(), uuid -> ExpiringMap.builder().expiration(this.cacheExpiry, TimeUnit.MILLISECONDS).build()).put(text, deserialized);
            return deserialized;
        })).exceptionally(e -> {
            if (!requester.isConnected()) {
                return Component.text(text);
            }
            if (this.checkLastError()) {
                return Component.text(text);
            }
            if (!(e instanceof CompletionException)) {
                if (!Arrays.stream(e.getSuppressed()).anyMatch(TimeoutException.class::isInstance)) {
                    plugin.log(Level.WARNING, "Failed to format placeholders for %s".formatted(requester.getUsername()), (Throwable)e);
                    return Component.text(text);
                }
            }
            plugin.log(Level.WARNING, "Timed out formatting placeholders for %s after %sms.Is PAPIProxyBridge up-to-date and installed on all backend servers?".formatted(requester.getUsername(), this.getRequestTimeout()), new Throwable[0]);
            return Component.text(text);
        });
    }

    public CompletableFuture<Component> formatComponentPlaceholders(@NotNull String text, @NotNull OnlineUser player) {
        return this.formatComponentPlaceholders(text, player, player.getUniqueId());
    }

    public CompletableFuture<Component> formatComponentPlaceholders(@NotNull String text, @NotNull UUID requester, @NotNull UUID formatFor) {
        return plugin.findPlayer(requester).map(onlineRequester -> this.formatComponentPlaceholders(text, (OnlineUser)onlineRequester, formatFor)).orElse(CompletableFuture.completedFuture(Component.text(text)));
    }

    public CompletableFuture<Component> formatComponentPlaceholders(@NotNull String text, @NotNull UUID player) {
        return plugin.findPlayer(player).map(requester -> this.formatComponentPlaceholders(text, (OnlineUser)requester, player)).orElse(CompletableFuture.completedFuture(Component.text(text)));
    }

    @Deprecated(since="1.6", forRemoval=true)
    public CompletableFuture<List<String>> findServers() throws UnsupportedOperationException {
        return plugin.findServers(this.requestTimeout);
    }

    public CompletableFuture<Set<String>> getServers() throws UnsupportedOperationException {
        return plugin.getServers(this.requestTimeout);
    }

    public void setRequestTimeout(long requestTimeout) {
        if (requestTimeout < 0L) {
            throw new IllegalArgumentException("Request timeout cannot be negative");
        }
        this.requestTimeout = requestTimeout;
    }

    public void setCacheExpiry(long cacheExpiry) {
        if (cacheExpiry < 0L) {
            throw new IllegalArgumentException("Cache expiry cannot be negative");
        }
        this.cacheExpiry = cacheExpiry;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getCacheExpiry() {
        return this.cacheExpiry;
    }

    public void setRetryTimes(int retryTimes) {
        if (retryTimes < 0) {
            throw new IllegalArgumentException("Retry times cannot be negative");
        }
        this.retryTimes = retryTimes;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public Settings.MessengerType getMessengerType() {
        return plugin.getSettings().getMessenger();
    }

    private boolean checkLastError() {
        if (System.currentTimeMillis() - this.lastError < 10000L) {
            return true;
        }
        this.lastError = System.currentTimeMillis();
        return false;
    }

    static {
        SCHEDULER = Executors.newScheduledThreadPool(1, r -> new Thread(r, "PAPIProxyBridge-PlaceholderAPI-ScheduledThread"));
    }
}

