/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.william278.papiproxybridge.libraries.lettuce.core.CompositeArgument;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceAssert;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandKeyword;

public class TrackingArgs
implements CompositeArgument {
    private boolean enabled;
    private Long redirect;
    private boolean bcast;
    private String[] prefixes;
    private Charset prefixCharset = StandardCharsets.UTF_8;
    private boolean optin;
    private boolean optout;
    private boolean noloop;

    public TrackingArgs enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public TrackingArgs redirect(long clientId) {
        this.redirect = clientId;
        return this;
    }

    public TrackingArgs bcast() {
        this.bcast = true;
        return this;
    }

    public TrackingArgs prefixes(String ... prefixes) {
        return this.prefixes(StandardCharsets.UTF_8, prefixes);
    }

    public TrackingArgs prefixes(Charset charset, String ... prefixes) {
        LettuceAssert.notNull((Object)charset, "Charset must not be null");
        this.prefixCharset = charset;
        this.prefixes = prefixes;
        return this;
    }

    public TrackingArgs optin() {
        this.optin = true;
        return this;
    }

    public TrackingArgs optout() {
        this.optout = true;
        return this;
    }

    public TrackingArgs noloop() {
        this.noloop = true;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        args.add(this.enabled ? CommandKeyword.ON : CommandKeyword.OFF);
        if (this.redirect != null) {
            args.add("REDIRECT").add(this.redirect);
        }
        if (this.prefixes != null) {
            for (String prefix : this.prefixes) {
                args.add("PREFIX").add(prefix.getBytes(this.prefixCharset));
            }
        }
        if (this.bcast) {
            args.add("BCAST");
        }
        if (this.optin) {
            args.add("OPTIN");
        }
        if (this.optout) {
            args.add("OPTOUT");
        }
        if (this.noloop) {
            args.add("NOLOOP");
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static TrackingArgs enabled() {
            return Builder.enabled(true);
        }

        public static TrackingArgs enabled(boolean enabled) {
            return new TrackingArgs().enabled(enabled);
        }
    }
}

