/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.william278.papiproxybridge.libraries.lettuce.core.GeoCoordinates;
import net.william278.papiproxybridge.libraries.lettuce.core.Value;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceAssert;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.ListSubscriber;
import net.william278.papiproxybridge.libraries.lettuce.core.output.OutputFactory;
import net.william278.papiproxybridge.libraries.lettuce.core.output.StreamingOutput;

public class GeoCoordinatesValueListOutput<K, V>
extends CommandOutput<K, V, List<Value<GeoCoordinates>>>
implements StreamingOutput<Value<GeoCoordinates>> {
    boolean hasX;
    private Double x;
    private boolean initialized;
    private StreamingOutput.Subscriber<Value<GeoCoordinates>> subscriber;

    public GeoCoordinatesValueListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<Value<GeoCoordinates>>)ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null) {
            this.subscriber.onNext((Collection)this.output, Value.empty());
            return;
        }
        double value = Double.parseDouble(this.decodeString(bytes));
        this.set(value);
    }

    @Override
    public void set(double number) {
        if (!this.hasX) {
            this.x = number;
            this.hasX = true;
            return;
        }
        this.subscriber.onNext((Collection)this.output, Value.fromNullable(new GeoCoordinates(this.x, number)));
        this.x = null;
        this.hasX = false;
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count / 2);
            this.initialized = true;
        }
        if (count == -1) {
            this.subscriber.onNext((Collection)this.output, Value.empty());
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<Value<GeoCoordinates>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<Value<GeoCoordinates>> getSubscriber() {
        return this.subscriber;
    }
}

