/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceAssert;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.ListSubscriber;
import net.william278.papiproxybridge.libraries.lettuce.core.output.OutputFactory;
import net.william278.papiproxybridge.libraries.lettuce.core.output.StreamingOutput;

public class KeyListOutput<K, V>
extends CommandOutput<K, V, List<K>>
implements StreamingOutput<K> {
    private boolean initialized;
    private StreamingOutput.Subscriber<K> subscriber;

    public KeyListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber(ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null) {
            return;
        }
        this.subscriber.onNext((Collection)this.output, bytes == null ? null : (Object)this.codec.decodeKey(bytes));
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<K> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<K> getSubscriber() {
        return this.subscriber;
    }
}

