/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import net.william278.papiproxybridge.libraries.lettuce.core.KeyValue;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.OutputFactory;

public class KeyValueValueListOutput<K, V>
extends CommandOutput<K, V, KeyValue<K, List<V>>> {
    private K key;
    private boolean hasKey;
    private List<V> values = Collections.emptyList();

    public KeyValueValueListOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes != null) {
            if (!this.hasKey) {
                this.key = this.codec.decodeKey(bytes);
                this.hasKey = true;
            } else {
                Object value = this.codec.decodeValue(bytes);
                this.values.add(value);
            }
        }
    }

    @Override
    public void multi(int count) {
        this.values = OutputFactory.newList(count);
    }

    @Override
    public void complete(int depth) {
        if (depth == 0 && this.hasKey) {
            this.output = KeyValue.just(this.key, this.values);
        }
    }
}

