/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.pubsub;

import java.lang.reflect.Array;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.william278.papiproxybridge.libraries.lettuce.core.ClientOptions;
import net.william278.papiproxybridge.libraries.lettuce.core.RedisChannelWriter;
import net.william278.papiproxybridge.libraries.lettuce.core.RedisCommandExecutionException;
import net.william278.papiproxybridge.libraries.lettuce.core.RedisFuture;
import net.william278.papiproxybridge.libraries.lettuce.core.StatefulRedisConnectionImpl;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.pubsub.PubSubEndpoint;
import net.william278.papiproxybridge.libraries.lettuce.core.pubsub.RedisPubSubAsyncCommandsImpl;
import net.william278.papiproxybridge.libraries.lettuce.core.pubsub.RedisPubSubListener;
import net.william278.papiproxybridge.libraries.lettuce.core.pubsub.RedisPubSubReactiveCommandsImpl;
import net.william278.papiproxybridge.libraries.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import net.william278.papiproxybridge.libraries.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import net.william278.papiproxybridge.libraries.lettuce.core.pubsub.api.reactive.RedisPubSubReactiveCommands;
import net.william278.papiproxybridge.libraries.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import net.william278.papiproxybridge.libraries.netty.util.internal.logging.InternalLoggerFactory;

public class StatefulRedisPubSubConnectionImpl<K, V>
extends StatefulRedisConnectionImpl<K, V>
implements StatefulRedisPubSubConnection<K, V> {
    private final PubSubEndpoint<K, V> endpoint;

    public StatefulRedisPubSubConnectionImpl(PubSubEndpoint<K, V> endpoint, RedisChannelWriter writer, RedisCodec<K, V> codec, Duration timeout) {
        super(writer, endpoint, codec, timeout, ClientOptions.DEFAULT_JSON_PARSER);
        this.endpoint = endpoint;
        endpoint.setConnectionState(this.getConnectionState());
    }

    @Override
    public void addListener(RedisPubSubListener<K, V> listener) {
        this.endpoint.addListener(listener);
    }

    @Override
    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.endpoint.removeListener(listener);
    }

    @Override
    public RedisPubSubAsyncCommands<K, V> async() {
        return (RedisPubSubAsyncCommands)((Object)this.async);
    }

    @Override
    protected RedisPubSubAsyncCommandsImpl<K, V> newRedisAsyncCommandsImpl() {
        return new RedisPubSubAsyncCommandsImpl(this, this.codec);
    }

    @Override
    public RedisPubSubCommands<K, V> sync() {
        return (RedisPubSubCommands)this.sync;
    }

    @Override
    protected RedisPubSubCommands<K, V> newRedisSyncCommandsImpl() {
        return (RedisPubSubCommands)this.syncHandler(this.async(), RedisPubSubCommands.class);
    }

    @Override
    public RedisPubSubReactiveCommands<K, V> reactive() {
        return (RedisPubSubReactiveCommands)((Object)this.reactive);
    }

    @Override
    protected RedisPubSubReactiveCommandsImpl<K, V> newRedisReactiveCommandsImpl() {
        return new RedisPubSubReactiveCommandsImpl(this, this.codec);
    }

    protected List<RedisFuture<Void>> resubscribe() {
        ArrayList<RedisFuture<Void>> result = new ArrayList<RedisFuture<Void>>();
        if (this.endpoint.hasChannelSubscriptions()) {
            result.add(this.async().subscribe(this.toArray(this.endpoint.getChannels())));
        }
        if (this.endpoint.hasShardChannelSubscriptions()) {
            result.add(this.async().ssubscribe(this.toArray(this.endpoint.getShardChannels())));
        }
        if (this.endpoint.hasPatternSubscriptions()) {
            result.add(this.async().psubscribe(this.toArray(this.endpoint.getPatterns())));
        }
        return result;
    }

    private <T> T[] toArray(Collection<T> c) {
        Class<?> cls = c.iterator().next().getClass();
        Object[] array = (Object[])Array.newInstance(cls, c.size());
        return c.toArray(array);
    }

    @Override
    public void activated() {
        super.activated();
        for (RedisFuture<Void> command : this.resubscribe()) {
            command.exceptionally(throwable -> {
                if (throwable instanceof RedisCommandExecutionException) {
                    InternalLoggerFactory.getInstance(this.getClass()).warn("Re-subscribe failed: " + command.getError());
                }
                return null;
            });
        }
    }
}

