/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.sentinel;

import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import net.william278.papiproxybridge.libraries.lettuce.core.ClientListArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.KillArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceAssert;
import net.william278.papiproxybridge.libraries.lettuce.core.output.IntegerOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.KeyOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.ListOfMapsOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.MapOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.SocketAddressOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.StatusOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.BaseRedisCommandBuilder;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.Command;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandKeyword;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandType;

class SentinelCommandBuilder<K, V>
extends BaseRedisCommandBuilder<K, V> {
    public SentinelCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    public Command<K, V, SocketAddress> getMasterAddrByKey(K key) {
        CommandArgs args = new CommandArgs(this.codec).add("get-master-addr-by-name").addKey(key);
        return this.createCommand(CommandType.SENTINEL, new SocketAddressOutput(this.codec), args);
    }

    public Command<K, V, List<Map<K, V>>> masters() {
        CommandArgs args = new CommandArgs(this.codec).add("masters");
        return this.createCommand(CommandType.SENTINEL, new ListOfMapsOutput(this.codec), args);
    }

    public Command<K, V, Map<K, V>> master(K key) {
        CommandArgs args = new CommandArgs(this.codec).add("master").addKey(key);
        return this.createCommand(CommandType.SENTINEL, new MapOutput(this.codec), args);
    }

    public Command<K, V, List<Map<K, V>>> slaves(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SLAVES).addKey(key);
        return this.createCommand(CommandType.SENTINEL, new ListOfMapsOutput(this.codec), args);
    }

    public Command<K, V, List<Map<K, V>>> replicas(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.REPLICAS).addKey(key);
        return this.createCommand(CommandType.SENTINEL, new ListOfMapsOutput(this.codec), args);
    }

    public Command<K, V, Long> reset(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.RESET).addKey(key);
        return this.createCommand(CommandType.SENTINEL, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> failover(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.FAILOVER).addKey(key);
        return this.createCommand(CommandType.SENTINEL, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> monitor(K key, String ip, int port, int quorum) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.MONITOR).addKey(key).add(ip).add(port).add(quorum);
        return this.createCommand(CommandType.SENTINEL, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> set(K key, String option, V value) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandType.SET).addKey(key).add(option).addValue(value);
        return this.createCommand(CommandType.SENTINEL, new StatusOutput(this.codec), args);
    }

    public Command<K, V, K> clientGetname() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.GETNAME);
        return this.createCommand(CommandType.CLIENT, new KeyOutput(this.codec), args);
    }

    public Command<K, V, String> clientSetname(K name) {
        LettuceAssert.notNull(name, "Name must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETNAME).addKey(name);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clientSetinfo(String key, String value) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.SETINFO).add(key).add(value);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clientKill(String addr) {
        LettuceAssert.notNull((Object)addr, "Addr must not be null");
        LettuceAssert.notEmpty((CharSequence)addr, "Addr must not be empty");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.KILL).add(addr);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, Long> clientKill(KillArgs killArgs) {
        LettuceAssert.notNull((Object)killArgs, "KillArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.KILL);
        killArgs.build(args);
        return this.createCommand(CommandType.CLIENT, new IntegerOutput(this.codec), args);
    }

    public Command<K, V, String> clientPause(long timeout) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.PAUSE).add(timeout);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clientList() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.LIST);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clientList(ClientListArgs clientListArgs) {
        LettuceAssert.notNull((Object)clientListArgs, "ClientListArgs must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.LIST);
        clientListArgs.build(args);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> clientInfo() {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.INFO);
        return this.createCommand(CommandType.CLIENT, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> info() {
        return this.createCommand(CommandType.INFO, new StatusOutput(this.codec));
    }

    public Command<K, V, String> info(String section) {
        LettuceAssert.notNull((Object)section, "Section must not be null");
        CommandArgs args = new CommandArgs(this.codec).add(section);
        return this.createCommand(CommandType.INFO, new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> ping() {
        return this.createCommand(CommandType.PING, new StatusOutput(this.codec));
    }

    public Command<K, V, String> remove(K key) {
        CommandArgs args = new CommandArgs(this.codec).add(CommandKeyword.REMOVE).addKey(key);
        return this.createCommand(CommandType.SENTINEL, new StatusOutput(this.codec), args);
    }
}

