/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.sentinel;

import java.time.Duration;
import java.util.Collection;
import java.util.function.Supplier;
import net.william278.papiproxybridge.libraries.lettuce.core.ClientOptions;
import net.william278.papiproxybridge.libraries.lettuce.core.ConnectionState;
import net.william278.papiproxybridge.libraries.lettuce.core.RedisChannelHandler;
import net.william278.papiproxybridge.libraries.lettuce.core.RedisChannelWriter;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.StringCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.json.JsonParser;
import net.william278.papiproxybridge.libraries.lettuce.core.output.StatusOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.AsyncCommand;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.Command;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandArgs;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandKeyword;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandType;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.RedisCommand;
import net.william278.papiproxybridge.libraries.lettuce.core.sentinel.RedisSentinelAsyncCommandsImpl;
import net.william278.papiproxybridge.libraries.lettuce.core.sentinel.RedisSentinelReactiveCommandsImpl;
import net.william278.papiproxybridge.libraries.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import net.william278.papiproxybridge.libraries.lettuce.core.sentinel.api.async.RedisSentinelAsyncCommands;
import net.william278.papiproxybridge.libraries.lettuce.core.sentinel.api.reactive.RedisSentinelReactiveCommands;
import net.william278.papiproxybridge.libraries.lettuce.core.sentinel.api.sync.RedisSentinelCommands;

public class StatefulRedisSentinelConnectionImpl<K, V>
extends RedisChannelHandler<K, V>
implements StatefulRedisSentinelConnection<K, V> {
    protected final RedisCodec<K, V> codec;
    protected final RedisSentinelCommands<K, V> sync;
    protected final RedisSentinelAsyncCommands<K, V> async;
    protected final RedisSentinelReactiveCommands<K, V> reactive;
    private final SentinelConnectionState connectionState = new SentinelConnectionState();

    public StatefulRedisSentinelConnectionImpl(RedisChannelWriter writer, RedisCodec<K, V> codec, Duration timeout) {
        this(writer, codec, timeout, ClientOptions.DEFAULT_JSON_PARSER);
    }

    public StatefulRedisSentinelConnectionImpl(RedisChannelWriter writer, RedisCodec<K, V> codec, Duration timeout, Supplier<JsonParser> parser) {
        super(writer, timeout);
        this.codec = codec;
        this.async = new RedisSentinelAsyncCommandsImpl<K, V>(this, codec);
        this.sync = (RedisSentinelCommands)this.syncHandler(this.async, RedisSentinelCommands.class);
        this.reactive = new RedisSentinelReactiveCommandsImpl<K, V>(this, codec, parser);
    }

    @Override
    public <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> command) {
        return super.dispatch(command);
    }

    @Override
    public Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> commands) {
        return super.dispatch(commands);
    }

    @Override
    public RedisSentinelCommands<K, V> sync() {
        return this.sync;
    }

    @Override
    public RedisSentinelAsyncCommands<K, V> async() {
        return this.async;
    }

    @Override
    public RedisSentinelReactiveCommands<K, V> reactive() {
        return this.reactive;
    }

    @Deprecated
    public void setClientName(String clientName) {
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.SETNAME).addValue(clientName);
        AsyncCommand async = new AsyncCommand(new Command(CommandType.CLIENT, new StatusOutput<String, String>(StringCodec.UTF8), args));
        this.connectionState.setClientName(clientName);
        this.dispatch(async);
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    static class SentinelConnectionState
    extends ConnectionState {
        SentinelConnectionState() {
        }

        @Override
        protected void setClientName(String clientName) {
            super.setClientName(clientName);
        }
    }
}

