/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.configlib;

import java.nio.charset.Charset;
import net.william278.papiproxybridge.libraries.configlib.ConfigurationProperties;

public class FileConfigurationProperties
extends ConfigurationProperties {
    private final String header;
    private final String footer;
    private final boolean createParentDirectories;
    private final Charset charset;

    protected FileConfigurationProperties(Builder<?> builder) {
        super(builder);
        this.header = builder.header;
        this.footer = builder.footer;
        this.createParentDirectories = builder.createParentDirectories;
        this.charset = builder.charset;
    }

    public static Builder<?> newBuilder() {
        return new BuilderImpl();
    }

    public Builder<?> toBuilder() {
        return new BuilderImpl(this);
    }

    public final String getHeader() {
        return this.header;
    }

    public final String getFooter() {
        return this.footer;
    }

    public final boolean createParentDirectories() {
        return this.createParentDirectories;
    }

    public final Charset getCharset() {
        return this.charset;
    }

    public static abstract class Builder<B extends Builder<B>>
    extends ConfigurationProperties.Builder<B> {
        private String header = null;
        private String footer = null;
        private boolean createParentDirectories = true;
        private Charset charset = Charset.defaultCharset();

        protected Builder() {
        }

        protected Builder(FileConfigurationProperties properties) {
            super(properties);
            this.header = properties.header;
            this.footer = properties.footer;
            this.createParentDirectories = properties.createParentDirectories;
            this.charset = properties.charset;
        }

        public final B header(String header) {
            this.header = header;
            return (B)this.getThis();
        }

        public final B footer(String footer) {
            this.footer = footer;
            return (B)this.getThis();
        }

        public final B createParentDirectories(boolean createParentDirectories) {
            this.createParentDirectories = createParentDirectories;
            return (B)this.getThis();
        }

        public final B charset(Charset charset) {
            this.charset = charset;
            return (B)this.getThis();
        }

        @Override
        public abstract FileConfigurationProperties build();

        @Override
        protected abstract B getThis();
    }

    private static final class BuilderImpl
    extends Builder<BuilderImpl> {
        private BuilderImpl() {
        }

        private BuilderImpl(FileConfigurationProperties properties) {
            super(properties);
        }

        @Override
        protected BuilderImpl getThis() {
            return this;
        }

        @Override
        public FileConfigurationProperties build() {
            return new FileConfigurationProperties(this);
        }
    }
}

