/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import lombok.Generated;
import net.william278.papiproxybridge.PAPIProxyBridge;
import net.william278.papiproxybridge.api.PlaceholderAPI;
import net.william278.papiproxybridge.config.Settings;
import net.william278.papiproxybridge.libraries.bstats.bukkit.Metrics;
import net.william278.papiproxybridge.libraries.bstats.charts.SimplePie;
import net.william278.papiproxybridge.messenger.Messenger;
import net.william278.papiproxybridge.messenger.PluginMessageMessenger;
import net.william278.papiproxybridge.messenger.redis.RedisMessenger;
import net.william278.papiproxybridge.papi.Formatter;
import net.william278.papiproxybridge.user.BukkitUser;
import net.william278.papiproxybridge.user.OnlineUser;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BukkitPAPIProxyBridge
extends JavaPlugin
implements PAPIProxyBridge,
Listener {
    private Formatter formatter;
    private Map<UUID, BukkitUser> users;
    private Settings settings;
    private Messenger messenger;
    private ExecutorService executorService;

    public void onLoad() {
        this.users = Maps.newConcurrentMap();
        this.executorService = Executors.newFixedThreadPool(2);
        this.formatter = new Formatter();
    }

    public void onEnable() {
        this.loadConfig();
        this.loadMessenger();
        this.messenger.onEnable();
        PlaceholderAPI.register(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.loadOnlinePlayers();
        this.setupMetrics();
        this.getLogger().info(this.getLoadMessage());
    }

    public void onDisable() {
        this.messenger.onDisable();
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 17880);
        metrics.addCustomChart(new SimplePie("messengerType", () -> this.getSettings().getMessenger().name()));
    }

    private void loadOnlinePlayers() {
        this.users.clear();
        this.getServer().getOnlinePlayers().forEach(player -> {
            BukkitUser user = BukkitUser.adapt(player);
            this.users.put(player.getUniqueId(), user);
        });
    }

    @Override
    public String getServerType() {
        return this.getServer().getName();
    }

    @NotNull
    public Collection<BukkitUser> getOnlineUsers() {
        return this.users.values();
    }

    public Optional<BukkitUser> findPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(this.users.get(uuid));
    }

    @Override
    public CompletableFuture<String> createRequest(@NotNull String text, @NotNull OnlineUser requester, @NotNull UUID formatFor, boolean wantsJson, long requestTimeout) {
        return this.formatPlaceholders(formatFor, (BukkitUser)requester, text);
    }

    @Override
    public CompletableFuture<Set<String>> getServers(long requestTimeout) {
        throw new UnsupportedOperationException("Cannot fetch the list of servers from a backend Bukkit server.");
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        if (exceptions.length > 0) {
            this.getLogger().log(level, message, exceptions[0]);
        } else {
            this.getLogger().log(level, message);
        }
    }

    @NotNull
    public final CompletableFuture<String> formatPlaceholders(@NotNull UUID formatFor, @NotNull BukkitUser requester, @NotNull String text) {
        return CompletableFuture.supplyAsync(() -> this.formatter.formatPlaceholders(formatFor, requester.player(), text), this.executorService);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        BukkitUser user = BukkitUser.adapt(event.getPlayer());
        this.users.put(user.getUniqueId(), user);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.users.remove(event.getPlayer().getUniqueId());
    }

    @Override
    public void loadMessenger() {
        switch (this.settings.getMessenger()) {
            case REDIS: {
                this.messenger = new RedisMessenger(this, this.settings.getRedis(), true);
                break;
            }
            case PLUGIN_MESSAGE: {
                this.messenger = new PluginMessageMessenger(this);
            }
        }
        this.log(Level.INFO, "Loaded messenger " + this.settings.getMessenger().name(), new Throwable[0]);
    }

    @Generated
    public Formatter getFormatter() {
        return this.formatter;
    }

    @Generated
    public Map<UUID, BukkitUser> getUsers() {
        return this.users;
    }

    @Override
    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    @Generated
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Generated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

